/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SpanStatus {
    OK("OK"),
    ERROR("ERROR"),
    TIMEOUT("TIMEOUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SpanStatus> VALUE_MAP;
    private final String value;

    private SpanStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SpanStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SpanStatus> knownValues() {
        EnumSet<SpanStatus> knownValues = EnumSet.allOf(SpanStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SpanStatus.class, SpanStatus::toString);
    }
}

