/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.KnowledgeBaseSearchType;
import software.amazon.awssdk.services.qconnect.model.KnowledgeSource;
import software.amazon.awssdk.services.qconnect.model.RetrievalFilterConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrievalConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrievalConfiguration> {
    private static final SdkField<KnowledgeSource> KNOWLEDGE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("knowledgeSource").getter(RetrievalConfiguration.getter(RetrievalConfiguration::knowledgeSource)).setter(RetrievalConfiguration.setter(Builder::knowledgeSource)).constructor(KnowledgeSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeSource").build()}).build();
    private static final SdkField<RetrievalFilterConfiguration> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(RetrievalConfiguration.getter(RetrievalConfiguration::filter)).setter(RetrievalConfiguration.setter(Builder::filter)).constructor(RetrievalFilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfResults").getter(RetrievalConfiguration.getter(RetrievalConfiguration::numberOfResults)).setter(RetrievalConfiguration.setter(Builder::numberOfResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfResults").build()}).build();
    private static final SdkField<String> OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overrideKnowledgeBaseSearchType").getter(RetrievalConfiguration.getter(RetrievalConfiguration::overrideKnowledgeBaseSearchTypeAsString)).setter(RetrievalConfiguration.setter(Builder::overrideKnowledgeBaseSearchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideKnowledgeBaseSearchType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_SOURCE_FIELD, FILTER_FIELD, NUMBER_OF_RESULTS_FIELD, OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrievalConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final KnowledgeSource knowledgeSource;
    private final RetrievalFilterConfiguration filter;
    private final Integer numberOfResults;
    private final String overrideKnowledgeBaseSearchType;

    private RetrievalConfiguration(BuilderImpl builder) {
        this.knowledgeSource = builder.knowledgeSource;
        this.filter = builder.filter;
        this.numberOfResults = builder.numberOfResults;
        this.overrideKnowledgeBaseSearchType = builder.overrideKnowledgeBaseSearchType;
    }

    public final KnowledgeSource knowledgeSource() {
        return this.knowledgeSource;
    }

    public final RetrievalFilterConfiguration filter() {
        return this.filter;
    }

    public final Integer numberOfResults() {
        return this.numberOfResults;
    }

    public final KnowledgeBaseSearchType overrideKnowledgeBaseSearchType() {
        return KnowledgeBaseSearchType.fromValue(this.overrideKnowledgeBaseSearchType);
    }

    public final String overrideKnowledgeBaseSearchTypeAsString() {
        return this.overrideKnowledgeBaseSearchType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideKnowledgeBaseSearchTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalConfiguration)) {
            return false;
        }
        RetrievalConfiguration other = (RetrievalConfiguration)obj;
        return Objects.equals(this.knowledgeSource(), other.knowledgeSource()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.numberOfResults(), other.numberOfResults()) && Objects.equals(this.overrideKnowledgeBaseSearchTypeAsString(), other.overrideKnowledgeBaseSearchTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RetrievalConfiguration").add("KnowledgeSource", (Object)this.knowledgeSource()).add("Filter", (Object)this.filter()).add("NumberOfResults", (Object)this.numberOfResults()).add("OverrideKnowledgeBaseSearchType", (Object)this.overrideKnowledgeBaseSearchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeSource": {
                return Optional.ofNullable(clazz.cast(this.knowledgeSource()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "numberOfResults": {
                return Optional.ofNullable(clazz.cast(this.numberOfResults()));
            }
            case "overrideKnowledgeBaseSearchType": {
                return Optional.ofNullable(clazz.cast(this.overrideKnowledgeBaseSearchTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("knowledgeSource", KNOWLEDGE_SOURCE_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("numberOfResults", NUMBER_OF_RESULTS_FIELD);
        map.put("overrideKnowledgeBaseSearchType", OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievalConfiguration, T> g) {
        return obj -> g.apply((RetrievalConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KnowledgeSource knowledgeSource;
        private RetrievalFilterConfiguration filter;
        private Integer numberOfResults;
        private String overrideKnowledgeBaseSearchType;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalConfiguration model) {
            this.knowledgeSource(model.knowledgeSource);
            this.filter(model.filter);
            this.numberOfResults(model.numberOfResults);
            this.overrideKnowledgeBaseSearchType(model.overrideKnowledgeBaseSearchType);
        }

        public final KnowledgeSource.Builder getKnowledgeSource() {
            return this.knowledgeSource != null ? this.knowledgeSource.toBuilder() : null;
        }

        public final void setKnowledgeSource(KnowledgeSource.BuilderImpl knowledgeSource) {
            this.knowledgeSource = knowledgeSource != null ? knowledgeSource.build() : null;
        }

        @Override
        public final Builder knowledgeSource(KnowledgeSource knowledgeSource) {
            this.knowledgeSource = knowledgeSource;
            return this;
        }

        public final RetrievalFilterConfiguration.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(RetrievalFilterConfiguration.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(RetrievalFilterConfiguration filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getNumberOfResults() {
            return this.numberOfResults;
        }

        public final void setNumberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
        }

        @Override
        public final Builder numberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
            return this;
        }

        public final String getOverrideKnowledgeBaseSearchType() {
            return this.overrideKnowledgeBaseSearchType;
        }

        public final void setOverrideKnowledgeBaseSearchType(String overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType = overrideKnowledgeBaseSearchType;
        }

        @Override
        public final Builder overrideKnowledgeBaseSearchType(String overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType = overrideKnowledgeBaseSearchType;
            return this;
        }

        @Override
        public final Builder overrideKnowledgeBaseSearchType(KnowledgeBaseSearchType overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType(overrideKnowledgeBaseSearchType == null ? null : overrideKnowledgeBaseSearchType.toString());
            return this;
        }

        public RetrievalConfiguration build() {
            return new RetrievalConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrievalConfiguration> {
        public Builder knowledgeSource(KnowledgeSource var1);

        default public Builder knowledgeSource(Consumer<KnowledgeSource.Builder> knowledgeSource) {
            return this.knowledgeSource((KnowledgeSource)((KnowledgeSource.Builder)KnowledgeSource.builder().applyMutation(knowledgeSource)).build());
        }

        public Builder filter(RetrievalFilterConfiguration var1);

        default public Builder filter(Consumer<RetrievalFilterConfiguration.Builder> filter) {
            return this.filter((RetrievalFilterConfiguration)((RetrievalFilterConfiguration.Builder)RetrievalFilterConfiguration.builder().applyMutation(filter)).build());
        }

        public Builder numberOfResults(Integer var1);

        public Builder overrideKnowledgeBaseSearchType(String var1);

        public Builder overrideKnowledgeBaseSearchType(KnowledgeBaseSearchType var1);
    }
}

