/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChunkingStrategy {
    FIXED_SIZE("FIXED_SIZE"),
    NONE("NONE"),
    HIERARCHICAL("HIERARCHICAL"),
    SEMANTIC("SEMANTIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChunkingStrategy> VALUE_MAP;
    private final String value;

    private ChunkingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChunkingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChunkingStrategy> knownValues() {
        EnumSet<ChunkingStrategy> knownValues = EnumSet.allOf(ChunkingStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChunkingStrategy.class, ChunkingStrategy::toString);
    }
}

