/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.SearchSessionsRequest;
import software.amazon.awssdk.services.qconnect.model.SearchSessionsResponse;
import software.amazon.awssdk.services.qconnect.model.SessionSummary;

public class SearchSessionsIterable
implements SdkIterable<SearchSessionsResponse> {
    private final QConnectClient client;
    private final SearchSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchSessionsIterable(QConnectClient client, SearchSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchSessionsResponseFetcher();
    }

    public Iterator<SearchSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SessionSummary> sessionSummaries() {
        Function<SearchSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessionSummaries() != null) {
                return response.sessionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchSessionsResponseFetcher
    implements SyncPageFetcher<SearchSessionsResponse> {
        private SearchSessionsResponseFetcher() {
        }

        public boolean hasNextPage(SearchSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchSessionsResponse nextPage(SearchSessionsResponse previousPage) {
            if (previousPage == null) {
                return SearchSessionsIterable.this.client.searchSessions(SearchSessionsIterable.this.firstRequest);
            }
            return SearchSessionsIterable.this.client.searchSessions((SearchSessionsRequest)((Object)SearchSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

