/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIPromptVersionSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse;

public class ListAIPromptVersionsIterable
implements SdkIterable<ListAiPromptVersionsResponse> {
    private final QConnectClient client;
    private final ListAiPromptVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAIPromptVersionsIterable(QConnectClient client, ListAiPromptVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAiPromptVersionsResponseFetcher();
    }

    public Iterator<ListAiPromptVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AIPromptVersionSummary> aiPromptVersionSummaries() {
        Function<ListAiPromptVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiPromptVersionSummaries() != null) {
                return response.aiPromptVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAiPromptVersionsResponseFetcher
    implements SyncPageFetcher<ListAiPromptVersionsResponse> {
        private ListAiPromptVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiPromptVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAiPromptVersionsResponse nextPage(ListAiPromptVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAIPromptVersionsIterable.this.client.listAIPromptVersions(ListAIPromptVersionsIterable.this.firstRequest);
            }
            return ListAIPromptVersionsIterable.this.client.listAIPromptVersions((ListAiPromptVersionsRequest)((Object)ListAIPromptVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

