/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.services.qconnect.model.RuntimeSessionData;
import software.amazon.awssdk.services.qconnect.model.RuntimeSessionDataListCopier;
import software.amazon.awssdk.services.qconnect.model.SessionDataNamespace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSessionDataResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, UpdateSessionDataResponse> {
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionArn").getter(UpdateSessionDataResponse.getter(UpdateSessionDataResponse::sessionArn)).setter(UpdateSessionDataResponse.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(UpdateSessionDataResponse.getter(UpdateSessionDataResponse::sessionId)).setter(UpdateSessionDataResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(UpdateSessionDataResponse.getter(UpdateSessionDataResponse::namespaceAsString)).setter(UpdateSessionDataResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<List<RuntimeSessionData>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("data").getter(UpdateSessionDataResponse.getter(UpdateSessionDataResponse::data)).setter(UpdateSessionDataResponse.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuntimeSessionData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ARN_FIELD, SESSION_ID_FIELD, NAMESPACE_FIELD, DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSessionDataResponse.memberNameToFieldInitializer();
    private final String sessionArn;
    private final String sessionId;
    private final String namespace;
    private final List<RuntimeSessionData> data;

    private UpdateSessionDataResponse(BuilderImpl builder) {
        super(builder);
        this.sessionArn = builder.sessionArn;
        this.sessionId = builder.sessionId;
        this.namespace = builder.namespace;
        this.data = builder.data;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final SessionDataNamespace namespace() {
        return SessionDataNamespace.fromValue(this.namespace);
    }

    public final String namespaceAsString() {
        return this.namespace;
    }

    public final boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructList);
    }

    public final List<RuntimeSessionData> data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasData() ? this.data() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionDataResponse)) {
            return false;
        }
        UpdateSessionDataResponse other = (UpdateSessionDataResponse)((Object)obj);
        return Objects.equals(this.sessionArn(), other.sessionArn()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.namespaceAsString(), other.namespaceAsString()) && this.hasData() == other.hasData() && Objects.equals(this.data(), other.data());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSessionDataResponse").add("SessionArn", (Object)this.sessionArn()).add("SessionId", (Object)this.sessionId()).add("Namespace", (Object)this.namespaceAsString()).add("Data", this.hasData() ? this.data() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespaceAsString()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("data", DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionDataResponse, T> g) {
        return obj -> g.apply((UpdateSessionDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private String sessionArn;
        private String sessionId;
        private String namespace;
        private List<RuntimeSessionData> data = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionDataResponse model) {
            super(model);
            this.sessionArn(model.sessionArn);
            this.sessionId(model.sessionId);
            this.namespace(model.namespace);
            this.data(model.data);
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(SessionDataNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final List<RuntimeSessionData.Builder> getData() {
            List<RuntimeSessionData.Builder> result = RuntimeSessionDataListCopier.copyToBuilder(this.data);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setData(Collection<RuntimeSessionData.BuilderImpl> data) {
            this.data = RuntimeSessionDataListCopier.copyFromBuilder(data);
        }

        @Override
        public final Builder data(Collection<RuntimeSessionData> data) {
            this.data = RuntimeSessionDataListCopier.copy(data);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(RuntimeSessionData ... data) {
            this.data(Arrays.asList(data));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Consumer<RuntimeSessionData.Builder> ... data) {
            this.data(Stream.of(data).map(c -> (RuntimeSessionData)((RuntimeSessionData.Builder)RuntimeSessionData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateSessionDataResponse build() {
            return new UpdateSessionDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSessionDataResponse> {
        public Builder sessionArn(String var1);

        public Builder sessionId(String var1);

        public Builder namespace(String var1);

        public Builder namespace(SessionDataNamespace var1);

        public Builder data(Collection<RuntimeSessionData> var1);

        public Builder data(RuntimeSessionData ... var1);

        public Builder data(Consumer<RuntimeSessionData.Builder> ... var1);
    }
}

