/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttributes;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateContentProvider;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMessageTemplateRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, UpdateMessageTemplateRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(UpdateMessageTemplateRequest.getter(UpdateMessageTemplateRequest::knowledgeBaseId)).setter(UpdateMessageTemplateRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageTemplateId").getter(UpdateMessageTemplateRequest.getter(UpdateMessageTemplateRequest::messageTemplateId)).setter(UpdateMessageTemplateRequest.setter(Builder::messageTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageTemplateId").build()}).build();
    private static final SdkField<MessageTemplateContentProvider> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(UpdateMessageTemplateRequest.getter(UpdateMessageTemplateRequest::content)).setter(UpdateMessageTemplateRequest.setter(Builder::content)).constructor(MessageTemplateContentProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(UpdateMessageTemplateRequest.getter(UpdateMessageTemplateRequest::language)).setter(UpdateMessageTemplateRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<MessageTemplateAttributes> DEFAULT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultAttributes").getter(UpdateMessageTemplateRequest.getter(UpdateMessageTemplateRequest::defaultAttributes)).setter(UpdateMessageTemplateRequest.setter(Builder::defaultAttributes)).constructor(MessageTemplateAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, MESSAGE_TEMPLATE_ID_FIELD, CONTENT_FIELD, LANGUAGE_FIELD, DEFAULT_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMessageTemplateRequest.memberNameToFieldInitializer();
    private final String knowledgeBaseId;
    private final String messageTemplateId;
    private final MessageTemplateContentProvider content;
    private final String language;
    private final MessageTemplateAttributes defaultAttributes;

    private UpdateMessageTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.messageTemplateId = builder.messageTemplateId;
        this.content = builder.content;
        this.language = builder.language;
        this.defaultAttributes = builder.defaultAttributes;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String messageTemplateId() {
        return this.messageTemplateId;
    }

    public final MessageTemplateContentProvider content() {
        return this.content;
    }

    public final String language() {
        return this.language;
    }

    public final MessageTemplateAttributes defaultAttributes() {
        return this.defaultAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMessageTemplateRequest)) {
            return false;
        }
        UpdateMessageTemplateRequest other = (UpdateMessageTemplateRequest)((Object)obj);
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.messageTemplateId(), other.messageTemplateId()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.defaultAttributes(), other.defaultAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMessageTemplateRequest").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("MessageTemplateId", (Object)this.messageTemplateId()).add("Content", (Object)this.content()).add("Language", (Object)this.language()).add("DefaultAttributes", (Object)this.defaultAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "messageTemplateId": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateId()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "defaultAttributes": {
                return Optional.ofNullable(clazz.cast(this.defaultAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("messageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("defaultAttributes", DEFAULT_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMessageTemplateRequest, T> g) {
        return obj -> g.apply((UpdateMessageTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String messageTemplateId;
        private MessageTemplateContentProvider content;
        private String language;
        private MessageTemplateAttributes defaultAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMessageTemplateRequest model) {
            super(model);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.messageTemplateId(model.messageTemplateId);
            this.content(model.content);
            this.language(model.language);
            this.defaultAttributes(model.defaultAttributes);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getMessageTemplateId() {
            return this.messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final MessageTemplateContentProvider.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(MessageTemplateContentProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MessageTemplateContentProvider content) {
            this.content = content;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final MessageTemplateAttributes.Builder getDefaultAttributes() {
            return this.defaultAttributes != null ? this.defaultAttributes.toBuilder() : null;
        }

        public final void setDefaultAttributes(MessageTemplateAttributes.BuilderImpl defaultAttributes) {
            this.defaultAttributes = defaultAttributes != null ? defaultAttributes.build() : null;
        }

        @Override
        public final Builder defaultAttributes(MessageTemplateAttributes defaultAttributes) {
            this.defaultAttributes = defaultAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMessageTemplateRequest build() {
            return new UpdateMessageTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMessageTemplateRequest> {
        public Builder knowledgeBaseId(String var1);

        public Builder messageTemplateId(String var1);

        public Builder content(MessageTemplateContentProvider var1);

        default public Builder content(Consumer<MessageTemplateContentProvider.Builder> content) {
            return this.content((MessageTemplateContentProvider)((MessageTemplateContentProvider.Builder)MessageTemplateContentProvider.builder().applyMutation(content)).build());
        }

        public Builder language(String var1);

        public Builder defaultAttributes(MessageTemplateAttributes var1);

        default public Builder defaultAttributes(Consumer<MessageTemplateAttributes.Builder> defaultAttributes) {
            return this.defaultAttributes((MessageTemplateAttributes)((MessageTemplateAttributes.Builder)MessageTemplateAttributes.builder().applyMutation(defaultAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

