/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AIAgentConfiguration;
import software.amazon.awssdk.services.qconnect.model.AIAgentType;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.services.qconnect.model.VisibilityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAiAgentRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, CreateAiAgentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAiAgentRequest.getter(CreateAiAgentRequest::clientToken)).setter(CreateAiAgentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(CreateAiAgentRequest.getter(CreateAiAgentRequest::assistantId)).setter(CreateAiAgentRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAiAgentRequest.getter(CreateAiAgentRequest::name)).setter(CreateAiAgentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateAiAgentRequest.getter(CreateAiAgentRequest::typeAsString)).setter(CreateAiAgentRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<AIAgentConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateAiAgentRequest.getter(CreateAiAgentRequest::configuration)).setter(CreateAiAgentRequest.setter(Builder::configuration)).constructor(AIAgentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visibilityStatus").getter(CreateAiAgentRequest.getter(CreateAiAgentRequest::visibilityStatusAsString)).setter(CreateAiAgentRequest.setter(Builder::visibilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAiAgentRequest.getter(CreateAiAgentRequest::tags)).setter(CreateAiAgentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAiAgentRequest.getter(CreateAiAgentRequest::description)).setter(CreateAiAgentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ASSISTANT_ID_FIELD, NAME_FIELD, TYPE_FIELD, CONFIGURATION_FIELD, VISIBILITY_STATUS_FIELD, TAGS_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAiAgentRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String assistantId;
    private final String name;
    private final String type;
    private final AIAgentConfiguration configuration;
    private final String visibilityStatus;
    private final Map<String, String> tags;
    private final String description;

    private CreateAiAgentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.assistantId = builder.assistantId;
        this.name = builder.name;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.visibilityStatus = builder.visibilityStatus;
        this.tags = builder.tags;
        this.description = builder.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String name() {
        return this.name;
    }

    public final AIAgentType type() {
        return AIAgentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final AIAgentConfiguration configuration() {
        return this.configuration;
    }

    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(this.visibilityStatus);
    }

    public final String visibilityStatusAsString() {
        return this.visibilityStatus;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAiAgentRequest)) {
            return false;
        }
        CreateAiAgentRequest other = (CreateAiAgentRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.visibilityStatusAsString(), other.visibilityStatusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAiAgentRequest").add("ClientToken", (Object)this.clientToken()).add("AssistantId", (Object)this.assistantId()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Configuration", (Object)this.configuration()).add("VisibilityStatus", (Object)this.visibilityStatusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "visibilityStatus": {
                return Optional.ofNullable(clazz.cast(this.visibilityStatusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAiAgentRequest, T> g) {
        return obj -> g.apply((CreateAiAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String assistantId;
        private String name;
        private String type;
        private AIAgentConfiguration configuration;
        private String visibilityStatus;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAiAgentRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.assistantId(model.assistantId);
            this.name(model.name);
            this.type(model.type);
            this.configuration(model.configuration);
            this.visibilityStatus(model.visibilityStatus);
            this.tags(model.tags);
            this.description(model.description);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AIAgentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AIAgentConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AIAgentConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AIAgentConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getVisibilityStatus() {
            return this.visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAiAgentRequest build() {
            return new CreateAiAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAiAgentRequest> {
        public Builder clientToken(String var1);

        public Builder assistantId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(AIAgentType var1);

        public Builder configuration(AIAgentConfiguration var1);

        default public Builder configuration(Consumer<AIAgentConfiguration.Builder> configuration) {
            return this.configuration((AIAgentConfiguration)((AIAgentConfiguration.Builder)AIAgentConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder visibilityStatus(String var1);

        public Builder visibilityStatus(VisibilityStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

