/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.Status;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.services.qconnect.model.VisibilityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AIGuardrailSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AIGuardrailSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AIGuardrailSummary.getter(AIGuardrailSummary::name)).setter(AIGuardrailSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(AIGuardrailSummary.getter(AIGuardrailSummary::assistantId)).setter(AIGuardrailSummary.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()}).build();
    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantArn").getter(AIGuardrailSummary.getter(AIGuardrailSummary::assistantArn)).setter(AIGuardrailSummary.setter(Builder::assistantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()}).build();
    private static final SdkField<String> AI_GUARDRAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiGuardrailId").getter(AIGuardrailSummary.getter(AIGuardrailSummary::aiGuardrailId)).setter(AIGuardrailSummary.setter(Builder::aiGuardrailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailId").build()}).build();
    private static final SdkField<String> AI_GUARDRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiGuardrailArn").getter(AIGuardrailSummary.getter(AIGuardrailSummary::aiGuardrailArn)).setter(AIGuardrailSummary.setter(Builder::aiGuardrailArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailArn").build()}).build();
    private static final SdkField<Instant> MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedTime").getter(AIGuardrailSummary.getter(AIGuardrailSummary::modifiedTime)).setter(AIGuardrailSummary.setter(Builder::modifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTime").build()}).build();
    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visibilityStatus").getter(AIGuardrailSummary.getter(AIGuardrailSummary::visibilityStatusAsString)).setter(AIGuardrailSummary.setter(Builder::visibilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AIGuardrailSummary.getter(AIGuardrailSummary::description)).setter(AIGuardrailSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AIGuardrailSummary.getter(AIGuardrailSummary::statusAsString)).setter(AIGuardrailSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(AIGuardrailSummary.getter(AIGuardrailSummary::tags)).setter(AIGuardrailSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ASSISTANT_ID_FIELD, ASSISTANT_ARN_FIELD, AI_GUARDRAIL_ID_FIELD, AI_GUARDRAIL_ARN_FIELD, MODIFIED_TIME_FIELD, VISIBILITY_STATUS_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AIGuardrailSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String assistantId;
    private final String assistantArn;
    private final String aiGuardrailId;
    private final String aiGuardrailArn;
    private final Instant modifiedTime;
    private final String visibilityStatus;
    private final String description;
    private final String status;
    private final Map<String, String> tags;

    private AIGuardrailSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.assistantId = builder.assistantId;
        this.assistantArn = builder.assistantArn;
        this.aiGuardrailId = builder.aiGuardrailId;
        this.aiGuardrailArn = builder.aiGuardrailArn;
        this.modifiedTime = builder.modifiedTime;
        this.visibilityStatus = builder.visibilityStatus;
        this.description = builder.description;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String assistantArn() {
        return this.assistantArn;
    }

    public final String aiGuardrailId() {
        return this.aiGuardrailId;
    }

    public final String aiGuardrailArn() {
        return this.aiGuardrailArn;
    }

    public final Instant modifiedTime() {
        return this.modifiedTime;
    }

    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(this.visibilityStatus);
    }

    public final String visibilityStatusAsString() {
        return this.visibilityStatus;
    }

    public final String description() {
        return this.description;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiGuardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIGuardrailSummary)) {
            return false;
        }
        AIGuardrailSummary other = (AIGuardrailSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.assistantArn(), other.assistantArn()) && Objects.equals(this.aiGuardrailId(), other.aiGuardrailId()) && Objects.equals(this.aiGuardrailArn(), other.aiGuardrailArn()) && Objects.equals(this.modifiedTime(), other.modifiedTime()) && Objects.equals(this.visibilityStatusAsString(), other.visibilityStatusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"AIGuardrailSummary").add("Name", (Object)this.name()).add("AssistantId", (Object)this.assistantId()).add("AssistantArn", (Object)this.assistantArn()).add("AiGuardrailId", (Object)this.aiGuardrailId()).add("AiGuardrailArn", (Object)this.aiGuardrailArn()).add("ModifiedTime", (Object)this.modifiedTime()).add("VisibilityStatus", (Object)this.visibilityStatusAsString()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "assistantArn": {
                return Optional.ofNullable(clazz.cast(this.assistantArn()));
            }
            case "aiGuardrailId": {
                return Optional.ofNullable(clazz.cast(this.aiGuardrailId()));
            }
            case "aiGuardrailArn": {
                return Optional.ofNullable(clazz.cast(this.aiGuardrailArn()));
            }
            case "modifiedTime": {
                return Optional.ofNullable(clazz.cast(this.modifiedTime()));
            }
            case "visibilityStatus": {
                return Optional.ofNullable(clazz.cast(this.visibilityStatusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        map.put("aiGuardrailId", AI_GUARDRAIL_ID_FIELD);
        map.put("aiGuardrailArn", AI_GUARDRAIL_ARN_FIELD);
        map.put("modifiedTime", MODIFIED_TIME_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIGuardrailSummary, T> g) {
        return obj -> g.apply((AIGuardrailSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String assistantId;
        private String assistantArn;
        private String aiGuardrailId;
        private String aiGuardrailArn;
        private Instant modifiedTime;
        private String visibilityStatus;
        private String description;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AIGuardrailSummary model) {
            this.name(model.name);
            this.assistantId(model.assistantId);
            this.assistantArn(model.assistantArn);
            this.aiGuardrailId(model.aiGuardrailId);
            this.aiGuardrailArn(model.aiGuardrailArn);
            this.modifiedTime(model.modifiedTime);
            this.visibilityStatus(model.visibilityStatus);
            this.description(model.description);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAssistantArn() {
            return this.assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAiGuardrailId() {
            return this.aiGuardrailId;
        }

        public final void setAiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
        }

        @Override
        public final Builder aiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
            return this;
        }

        public final String getAiGuardrailArn() {
            return this.aiGuardrailArn;
        }

        public final void setAiGuardrailArn(String aiGuardrailArn) {
            this.aiGuardrailArn = aiGuardrailArn;
        }

        @Override
        public final Builder aiGuardrailArn(String aiGuardrailArn) {
            this.aiGuardrailArn = aiGuardrailArn;
            return this;
        }

        public final Instant getModifiedTime() {
            return this.modifiedTime;
        }

        public final void setModifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        @Override
        public final Builder modifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public final String getVisibilityStatus() {
            return this.visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public AIGuardrailSummary build() {
            return new AIGuardrailSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AIGuardrailSummary> {
        public Builder name(String var1);

        public Builder assistantId(String var1);

        public Builder assistantArn(String var1);

        public Builder aiGuardrailId(String var1);

        public Builder aiGuardrailArn(String var1);

        public Builder modifiedTime(Instant var1);

        public Builder visibilityStatus(String var1);

        public Builder visibilityStatus(VisibilityStatus var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder tags(Map<String, String> var1);
    }
}

