/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailVersionSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailVersionsResponse;

public class ListAIGuardrailVersionsIterable
implements SdkIterable<ListAiGuardrailVersionsResponse> {
    private final QConnectClient client;
    private final ListAiGuardrailVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAIGuardrailVersionsIterable(QConnectClient client, ListAiGuardrailVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAiGuardrailVersionsResponseFetcher();
    }

    public Iterator<ListAiGuardrailVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AIGuardrailVersionSummary> aiGuardrailVersionSummaries() {
        Function<ListAiGuardrailVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiGuardrailVersionSummaries() != null) {
                return response.aiGuardrailVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAiGuardrailVersionsResponseFetcher
    implements SyncPageFetcher<ListAiGuardrailVersionsResponse> {
        private ListAiGuardrailVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiGuardrailVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAiGuardrailVersionsResponse nextPage(ListAiGuardrailVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAIGuardrailVersionsIterable.this.client.listAIGuardrailVersions(ListAIGuardrailVersionsIterable.this.firstRequest);
            }
            return ListAIGuardrailVersionsIterable.this.client.listAIGuardrailVersions((ListAiGuardrailVersionsRequest)((Object)ListAIGuardrailVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

