/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIAgentSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse;

public class ListAIAgentsIterable
implements SdkIterable<ListAiAgentsResponse> {
    private final QConnectClient client;
    private final ListAiAgentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAIAgentsIterable(QConnectClient client, ListAiAgentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAiAgentsResponseFetcher();
    }

    public Iterator<ListAiAgentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AIAgentSummary> aiAgentSummaries() {
        Function<ListAiAgentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiAgentSummaries() != null) {
                return response.aiAgentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAiAgentsResponseFetcher
    implements SyncPageFetcher<ListAiAgentsResponse> {
        private ListAiAgentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiAgentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAiAgentsResponse nextPage(ListAiAgentsResponse previousPage) {
            if (previousPage == null) {
                return ListAIAgentsIterable.this.client.listAIAgents(ListAIAgentsIterable.this.firstRequest);
            }
            return ListAIAgentsIterable.this.client.listAIAgents((ListAiAgentsRequest)((Object)ListAIAgentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

