/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.EmailMessageTemplateContent;
import software.amazon.awssdk.services.qconnect.model.SMSMessageTemplateContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageTemplateContentProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageTemplateContentProvider> {
    private static final SdkField<EmailMessageTemplateContent> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("email").getter(MessageTemplateContentProvider.getter(MessageTemplateContentProvider::email)).setter(MessageTemplateContentProvider.setter(Builder::email)).constructor(EmailMessageTemplateContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final SdkField<SMSMessageTemplateContent> SMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sms").getter(MessageTemplateContentProvider.getter(MessageTemplateContentProvider::sms)).setter(MessageTemplateContentProvider.setter(Builder::sms)).constructor(SMSMessageTemplateContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sms").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, SMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageTemplateContentProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EmailMessageTemplateContent email;
    private final SMSMessageTemplateContent sms;
    private final Type type;

    private MessageTemplateContentProvider(BuilderImpl builder) {
        this.email = builder.email;
        this.sms = builder.sms;
        this.type = builder.type;
    }

    public final EmailMessageTemplateContent email() {
        return this.email;
    }

    public final SMSMessageTemplateContent sms() {
        return this.sms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.sms());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateContentProvider)) {
            return false;
        }
        MessageTemplateContentProvider other = (MessageTemplateContentProvider)obj;
        return Objects.equals(this.email(), other.email()) && Objects.equals(this.sms(), other.sms());
    }

    public final String toString() {
        return ToString.builder((String)"MessageTemplateContentProvider").add("Email", (Object)this.email()).add("Sms", (Object)this.sms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "sms": {
                return Optional.ofNullable(clazz.cast(this.sms()));
            }
        }
        return Optional.empty();
    }

    public static MessageTemplateContentProvider fromEmail(EmailMessageTemplateContent email) {
        return (MessageTemplateContentProvider)MessageTemplateContentProvider.builder().email(email).build();
    }

    public static MessageTemplateContentProvider fromEmail(Consumer<EmailMessageTemplateContent.Builder> email) {
        EmailMessageTemplateContent.Builder builder = EmailMessageTemplateContent.builder();
        email.accept(builder);
        return MessageTemplateContentProvider.fromEmail((EmailMessageTemplateContent)builder.build());
    }

    public static MessageTemplateContentProvider fromSms(SMSMessageTemplateContent sms) {
        return (MessageTemplateContentProvider)MessageTemplateContentProvider.builder().sms(sms).build();
    }

    public static MessageTemplateContentProvider fromSms(Consumer<SMSMessageTemplateContent.Builder> sms) {
        SMSMessageTemplateContent.Builder builder = SMSMessageTemplateContent.builder();
        sms.accept(builder);
        return MessageTemplateContentProvider.fromSms((SMSMessageTemplateContent)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("email", EMAIL_FIELD);
        map.put("sms", SMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateContentProvider, T> g) {
        return obj -> g.apply((MessageTemplateContentProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EMAIL,
        SMS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EmailMessageTemplateContent email;
        private SMSMessageTemplateContent sms;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateContentProvider model) {
            this.email(model.email);
            this.sms(model.sms);
        }

        public final EmailMessageTemplateContent.Builder getEmail() {
            return this.email != null ? this.email.toBuilder() : null;
        }

        public final void setEmail(EmailMessageTemplateContent.BuilderImpl email) {
            EmailMessageTemplateContent oldValue = this.email;
            this.email = email != null ? email.build() : null;
            this.handleUnionValueChange(Type.EMAIL, oldValue, this.email);
        }

        @Override
        public final Builder email(EmailMessageTemplateContent email) {
            EmailMessageTemplateContent oldValue = this.email;
            this.email = email;
            this.handleUnionValueChange(Type.EMAIL, oldValue, this.email);
            return this;
        }

        public final SMSMessageTemplateContent.Builder getSms() {
            return this.sms != null ? this.sms.toBuilder() : null;
        }

        public final void setSms(SMSMessageTemplateContent.BuilderImpl sms) {
            SMSMessageTemplateContent oldValue = this.sms;
            this.sms = sms != null ? sms.build() : null;
            this.handleUnionValueChange(Type.SMS, oldValue, this.sms);
        }

        @Override
        public final Builder sms(SMSMessageTemplateContent sms) {
            SMSMessageTemplateContent oldValue = this.sms;
            this.sms = sms;
            this.handleUnionValueChange(Type.SMS, oldValue, this.sms);
            return this;
        }

        public MessageTemplateContentProvider build() {
            return new MessageTemplateContentProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageTemplateContentProvider> {
        public Builder email(EmailMessageTemplateContent var1);

        default public Builder email(Consumer<EmailMessageTemplateContent.Builder> email) {
            return this.email((EmailMessageTemplateContent)((EmailMessageTemplateContent.Builder)EmailMessageTemplateContent.builder().applyMutation(email)).build());
        }

        public Builder sms(SMSMessageTemplateContent var1);

        default public Builder sms(Consumer<SMSMessageTemplateContent.Builder> sms) {
            return this.sms((SMSMessageTemplateContent)((SMSMessageTemplateContent.Builder)SMSMessageTemplateContent.builder().applyMutation(sms)).build());
        }
    }
}

