/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailContentPolicyConfig;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailContextualGroundingPolicyConfig;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailSensitiveInformationPolicyConfig;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailTopicPolicyConfig;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailWordPolicyConfig;
import software.amazon.awssdk.services.qconnect.model.Status;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.services.qconnect.model.VisibilityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AIGuardrailData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AIGuardrailData> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(AIGuardrailData.getter(AIGuardrailData::assistantId)).setter(AIGuardrailData.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()}).build();
    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantArn").getter(AIGuardrailData.getter(AIGuardrailData::assistantArn)).setter(AIGuardrailData.setter(Builder::assistantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()}).build();
    private static final SdkField<String> AI_GUARDRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiGuardrailArn").getter(AIGuardrailData.getter(AIGuardrailData::aiGuardrailArn)).setter(AIGuardrailData.setter(Builder::aiGuardrailArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailArn").build()}).build();
    private static final SdkField<String> AI_GUARDRAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiGuardrailId").getter(AIGuardrailData.getter(AIGuardrailData::aiGuardrailId)).setter(AIGuardrailData.setter(Builder::aiGuardrailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AIGuardrailData.getter(AIGuardrailData::name)).setter(AIGuardrailData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visibilityStatus").getter(AIGuardrailData.getter(AIGuardrailData::visibilityStatusAsString)).setter(AIGuardrailData.setter(Builder::visibilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()}).build();
    private static final SdkField<String> BLOCKED_INPUT_MESSAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedInputMessaging").getter(AIGuardrailData.getter(AIGuardrailData::blockedInputMessaging)).setter(AIGuardrailData.setter(Builder::blockedInputMessaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedInputMessaging").build()}).build();
    private static final SdkField<String> BLOCKED_OUTPUTS_MESSAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedOutputsMessaging").getter(AIGuardrailData.getter(AIGuardrailData::blockedOutputsMessaging)).setter(AIGuardrailData.setter(Builder::blockedOutputsMessaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedOutputsMessaging").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AIGuardrailData.getter(AIGuardrailData::description)).setter(AIGuardrailData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<AIGuardrailTopicPolicyConfig> TOPIC_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("topicPolicyConfig").getter(AIGuardrailData.getter(AIGuardrailData::topicPolicyConfig)).setter(AIGuardrailData.setter(Builder::topicPolicyConfig)).constructor(AIGuardrailTopicPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicyConfig").build()}).build();
    private static final SdkField<AIGuardrailContentPolicyConfig> CONTENT_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentPolicyConfig").getter(AIGuardrailData.getter(AIGuardrailData::contentPolicyConfig)).setter(AIGuardrailData.setter(Builder::contentPolicyConfig)).constructor(AIGuardrailContentPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicyConfig").build()}).build();
    private static final SdkField<AIGuardrailWordPolicyConfig> WORD_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("wordPolicyConfig").getter(AIGuardrailData.getter(AIGuardrailData::wordPolicyConfig)).setter(AIGuardrailData.setter(Builder::wordPolicyConfig)).constructor(AIGuardrailWordPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicyConfig").build()}).build();
    private static final SdkField<AIGuardrailSensitiveInformationPolicyConfig> SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sensitiveInformationPolicyConfig").getter(AIGuardrailData.getter(AIGuardrailData::sensitiveInformationPolicyConfig)).setter(AIGuardrailData.setter(Builder::sensitiveInformationPolicyConfig)).constructor(AIGuardrailSensitiveInformationPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicyConfig").build()}).build();
    private static final SdkField<AIGuardrailContextualGroundingPolicyConfig> CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contextualGroundingPolicyConfig").getter(AIGuardrailData.getter(AIGuardrailData::contextualGroundingPolicyConfig)).setter(AIGuardrailData.setter(Builder::contextualGroundingPolicyConfig)).constructor(AIGuardrailContextualGroundingPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextualGroundingPolicyConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(AIGuardrailData.getter(AIGuardrailData::tags)).setter(AIGuardrailData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AIGuardrailData.getter(AIGuardrailData::statusAsString)).setter(AIGuardrailData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedTime").getter(AIGuardrailData.getter(AIGuardrailData::modifiedTime)).setter(AIGuardrailData.setter(Builder::modifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, ASSISTANT_ARN_FIELD, AI_GUARDRAIL_ARN_FIELD, AI_GUARDRAIL_ID_FIELD, NAME_FIELD, VISIBILITY_STATUS_FIELD, BLOCKED_INPUT_MESSAGING_FIELD, BLOCKED_OUTPUTS_MESSAGING_FIELD, DESCRIPTION_FIELD, TOPIC_POLICY_CONFIG_FIELD, CONTENT_POLICY_CONFIG_FIELD, WORD_POLICY_CONFIG_FIELD, SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD, CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD, TAGS_FIELD, STATUS_FIELD, MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AIGuardrailData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assistantId;
    private final String assistantArn;
    private final String aiGuardrailArn;
    private final String aiGuardrailId;
    private final String name;
    private final String visibilityStatus;
    private final String blockedInputMessaging;
    private final String blockedOutputsMessaging;
    private final String description;
    private final AIGuardrailTopicPolicyConfig topicPolicyConfig;
    private final AIGuardrailContentPolicyConfig contentPolicyConfig;
    private final AIGuardrailWordPolicyConfig wordPolicyConfig;
    private final AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;
    private final AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;
    private final Map<String, String> tags;
    private final String status;
    private final Instant modifiedTime;

    private AIGuardrailData(BuilderImpl builder) {
        this.assistantId = builder.assistantId;
        this.assistantArn = builder.assistantArn;
        this.aiGuardrailArn = builder.aiGuardrailArn;
        this.aiGuardrailId = builder.aiGuardrailId;
        this.name = builder.name;
        this.visibilityStatus = builder.visibilityStatus;
        this.blockedInputMessaging = builder.blockedInputMessaging;
        this.blockedOutputsMessaging = builder.blockedOutputsMessaging;
        this.description = builder.description;
        this.topicPolicyConfig = builder.topicPolicyConfig;
        this.contentPolicyConfig = builder.contentPolicyConfig;
        this.wordPolicyConfig = builder.wordPolicyConfig;
        this.sensitiveInformationPolicyConfig = builder.sensitiveInformationPolicyConfig;
        this.contextualGroundingPolicyConfig = builder.contextualGroundingPolicyConfig;
        this.tags = builder.tags;
        this.status = builder.status;
        this.modifiedTime = builder.modifiedTime;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String assistantArn() {
        return this.assistantArn;
    }

    public final String aiGuardrailArn() {
        return this.aiGuardrailArn;
    }

    public final String aiGuardrailId() {
        return this.aiGuardrailId;
    }

    public final String name() {
        return this.name;
    }

    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(this.visibilityStatus);
    }

    public final String visibilityStatusAsString() {
        return this.visibilityStatus;
    }

    public final String blockedInputMessaging() {
        return this.blockedInputMessaging;
    }

    public final String blockedOutputsMessaging() {
        return this.blockedOutputsMessaging;
    }

    public final String description() {
        return this.description;
    }

    public final AIGuardrailTopicPolicyConfig topicPolicyConfig() {
        return this.topicPolicyConfig;
    }

    public final AIGuardrailContentPolicyConfig contentPolicyConfig() {
        return this.contentPolicyConfig;
    }

    public final AIGuardrailWordPolicyConfig wordPolicyConfig() {
        return this.wordPolicyConfig;
    }

    public final AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig() {
        return this.sensitiveInformationPolicyConfig;
    }

    public final AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig() {
        return this.contextualGroundingPolicyConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant modifiedTime() {
        return this.modifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiGuardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedInputMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedOutputsMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitiveInformationPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextualGroundingPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIGuardrailData)) {
            return false;
        }
        AIGuardrailData other = (AIGuardrailData)obj;
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.assistantArn(), other.assistantArn()) && Objects.equals(this.aiGuardrailArn(), other.aiGuardrailArn()) && Objects.equals(this.aiGuardrailId(), other.aiGuardrailId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.visibilityStatusAsString(), other.visibilityStatusAsString()) && Objects.equals(this.blockedInputMessaging(), other.blockedInputMessaging()) && Objects.equals(this.blockedOutputsMessaging(), other.blockedOutputsMessaging()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.topicPolicyConfig(), other.topicPolicyConfig()) && Objects.equals(this.contentPolicyConfig(), other.contentPolicyConfig()) && Objects.equals(this.wordPolicyConfig(), other.wordPolicyConfig()) && Objects.equals(this.sensitiveInformationPolicyConfig(), other.sensitiveInformationPolicyConfig()) && Objects.equals(this.contextualGroundingPolicyConfig(), other.contextualGroundingPolicyConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.modifiedTime(), other.modifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"AIGuardrailData").add("AssistantId", (Object)this.assistantId()).add("AssistantArn", (Object)this.assistantArn()).add("AiGuardrailArn", (Object)this.aiGuardrailArn()).add("AiGuardrailId", (Object)this.aiGuardrailId()).add("Name", (Object)this.name()).add("VisibilityStatus", (Object)this.visibilityStatusAsString()).add("BlockedInputMessaging", (Object)(this.blockedInputMessaging() == null ? null : "*** Sensitive Data Redacted ***")).add("BlockedOutputsMessaging", (Object)(this.blockedOutputsMessaging() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("TopicPolicyConfig", (Object)this.topicPolicyConfig()).add("ContentPolicyConfig", (Object)this.contentPolicyConfig()).add("WordPolicyConfig", (Object)this.wordPolicyConfig()).add("SensitiveInformationPolicyConfig", (Object)this.sensitiveInformationPolicyConfig()).add("ContextualGroundingPolicyConfig", (Object)this.contextualGroundingPolicyConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("Status", (Object)this.statusAsString()).add("ModifiedTime", (Object)this.modifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "assistantArn": {
                return Optional.ofNullable(clazz.cast(this.assistantArn()));
            }
            case "aiGuardrailArn": {
                return Optional.ofNullable(clazz.cast(this.aiGuardrailArn()));
            }
            case "aiGuardrailId": {
                return Optional.ofNullable(clazz.cast(this.aiGuardrailId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "visibilityStatus": {
                return Optional.ofNullable(clazz.cast(this.visibilityStatusAsString()));
            }
            case "blockedInputMessaging": {
                return Optional.ofNullable(clazz.cast(this.blockedInputMessaging()));
            }
            case "blockedOutputsMessaging": {
                return Optional.ofNullable(clazz.cast(this.blockedOutputsMessaging()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "topicPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.topicPolicyConfig()));
            }
            case "contentPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.contentPolicyConfig()));
            }
            case "wordPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.wordPolicyConfig()));
            }
            case "sensitiveInformationPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.sensitiveInformationPolicyConfig()));
            }
            case "contextualGroundingPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.contextualGroundingPolicyConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "modifiedTime": {
                return Optional.ofNullable(clazz.cast(this.modifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        map.put("aiGuardrailArn", AI_GUARDRAIL_ARN_FIELD);
        map.put("aiGuardrailId", AI_GUARDRAIL_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("blockedInputMessaging", BLOCKED_INPUT_MESSAGING_FIELD);
        map.put("blockedOutputsMessaging", BLOCKED_OUTPUTS_MESSAGING_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("topicPolicyConfig", TOPIC_POLICY_CONFIG_FIELD);
        map.put("contentPolicyConfig", CONTENT_POLICY_CONFIG_FIELD);
        map.put("wordPolicyConfig", WORD_POLICY_CONFIG_FIELD);
        map.put("sensitiveInformationPolicyConfig", SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD);
        map.put("contextualGroundingPolicyConfig", CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("modifiedTime", MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIGuardrailData, T> g) {
        return obj -> g.apply((AIGuardrailData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assistantId;
        private String assistantArn;
        private String aiGuardrailArn;
        private String aiGuardrailId;
        private String name;
        private String visibilityStatus;
        private String blockedInputMessaging;
        private String blockedOutputsMessaging;
        private String description;
        private AIGuardrailTopicPolicyConfig topicPolicyConfig;
        private AIGuardrailContentPolicyConfig contentPolicyConfig;
        private AIGuardrailWordPolicyConfig wordPolicyConfig;
        private AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;
        private AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private Instant modifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AIGuardrailData model) {
            this.assistantId(model.assistantId);
            this.assistantArn(model.assistantArn);
            this.aiGuardrailArn(model.aiGuardrailArn);
            this.aiGuardrailId(model.aiGuardrailId);
            this.name(model.name);
            this.visibilityStatus(model.visibilityStatus);
            this.blockedInputMessaging(model.blockedInputMessaging);
            this.blockedOutputsMessaging(model.blockedOutputsMessaging);
            this.description(model.description);
            this.topicPolicyConfig(model.topicPolicyConfig);
            this.contentPolicyConfig(model.contentPolicyConfig);
            this.wordPolicyConfig(model.wordPolicyConfig);
            this.sensitiveInformationPolicyConfig(model.sensitiveInformationPolicyConfig);
            this.contextualGroundingPolicyConfig(model.contextualGroundingPolicyConfig);
            this.tags(model.tags);
            this.status(model.status);
            this.modifiedTime(model.modifiedTime);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAssistantArn() {
            return this.assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAiGuardrailArn() {
            return this.aiGuardrailArn;
        }

        public final void setAiGuardrailArn(String aiGuardrailArn) {
            this.aiGuardrailArn = aiGuardrailArn;
        }

        @Override
        public final Builder aiGuardrailArn(String aiGuardrailArn) {
            this.aiGuardrailArn = aiGuardrailArn;
            return this;
        }

        public final String getAiGuardrailId() {
            return this.aiGuardrailId;
        }

        public final void setAiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
        }

        @Override
        public final Builder aiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVisibilityStatus() {
            return this.visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final String getBlockedInputMessaging() {
            return this.blockedInputMessaging;
        }

        public final void setBlockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
        }

        @Override
        public final Builder blockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
            return this;
        }

        public final String getBlockedOutputsMessaging() {
            return this.blockedOutputsMessaging;
        }

        public final void setBlockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
        }

        @Override
        public final Builder blockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AIGuardrailTopicPolicyConfig.Builder getTopicPolicyConfig() {
            return this.topicPolicyConfig != null ? this.topicPolicyConfig.toBuilder() : null;
        }

        public final void setTopicPolicyConfig(AIGuardrailTopicPolicyConfig.BuilderImpl topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig != null ? topicPolicyConfig.build() : null;
        }

        @Override
        public final Builder topicPolicyConfig(AIGuardrailTopicPolicyConfig topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig;
            return this;
        }

        public final AIGuardrailContentPolicyConfig.Builder getContentPolicyConfig() {
            return this.contentPolicyConfig != null ? this.contentPolicyConfig.toBuilder() : null;
        }

        public final void setContentPolicyConfig(AIGuardrailContentPolicyConfig.BuilderImpl contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig != null ? contentPolicyConfig.build() : null;
        }

        @Override
        public final Builder contentPolicyConfig(AIGuardrailContentPolicyConfig contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig;
            return this;
        }

        public final AIGuardrailWordPolicyConfig.Builder getWordPolicyConfig() {
            return this.wordPolicyConfig != null ? this.wordPolicyConfig.toBuilder() : null;
        }

        public final void setWordPolicyConfig(AIGuardrailWordPolicyConfig.BuilderImpl wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig != null ? wordPolicyConfig.build() : null;
        }

        @Override
        public final Builder wordPolicyConfig(AIGuardrailWordPolicyConfig wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig;
            return this;
        }

        public final AIGuardrailSensitiveInformationPolicyConfig.Builder getSensitiveInformationPolicyConfig() {
            return this.sensitiveInformationPolicyConfig != null ? this.sensitiveInformationPolicyConfig.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig.BuilderImpl sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig != null ? sensitiveInformationPolicyConfig.build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig;
            return this;
        }

        public final AIGuardrailContextualGroundingPolicyConfig.Builder getContextualGroundingPolicyConfig() {
            return this.contextualGroundingPolicyConfig != null ? this.contextualGroundingPolicyConfig.toBuilder() : null;
        }

        public final void setContextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig.BuilderImpl contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig != null ? contextualGroundingPolicyConfig.build() : null;
        }

        @Override
        public final Builder contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getModifiedTime() {
            return this.modifiedTime;
        }

        public final void setModifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        @Override
        public final Builder modifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public AIGuardrailData build() {
            return new AIGuardrailData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AIGuardrailData> {
        public Builder assistantId(String var1);

        public Builder assistantArn(String var1);

        public Builder aiGuardrailArn(String var1);

        public Builder aiGuardrailId(String var1);

        public Builder name(String var1);

        public Builder visibilityStatus(String var1);

        public Builder visibilityStatus(VisibilityStatus var1);

        public Builder blockedInputMessaging(String var1);

        public Builder blockedOutputsMessaging(String var1);

        public Builder description(String var1);

        public Builder topicPolicyConfig(AIGuardrailTopicPolicyConfig var1);

        default public Builder topicPolicyConfig(Consumer<AIGuardrailTopicPolicyConfig.Builder> topicPolicyConfig) {
            return this.topicPolicyConfig((AIGuardrailTopicPolicyConfig)((AIGuardrailTopicPolicyConfig.Builder)AIGuardrailTopicPolicyConfig.builder().applyMutation(topicPolicyConfig)).build());
        }

        public Builder contentPolicyConfig(AIGuardrailContentPolicyConfig var1);

        default public Builder contentPolicyConfig(Consumer<AIGuardrailContentPolicyConfig.Builder> contentPolicyConfig) {
            return this.contentPolicyConfig((AIGuardrailContentPolicyConfig)((AIGuardrailContentPolicyConfig.Builder)AIGuardrailContentPolicyConfig.builder().applyMutation(contentPolicyConfig)).build());
        }

        public Builder wordPolicyConfig(AIGuardrailWordPolicyConfig var1);

        default public Builder wordPolicyConfig(Consumer<AIGuardrailWordPolicyConfig.Builder> wordPolicyConfig) {
            return this.wordPolicyConfig((AIGuardrailWordPolicyConfig)((AIGuardrailWordPolicyConfig.Builder)AIGuardrailWordPolicyConfig.builder().applyMutation(wordPolicyConfig)).build());
        }

        public Builder sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig var1);

        default public Builder sensitiveInformationPolicyConfig(Consumer<AIGuardrailSensitiveInformationPolicyConfig.Builder> sensitiveInformationPolicyConfig) {
            return this.sensitiveInformationPolicyConfig((AIGuardrailSensitiveInformationPolicyConfig)((AIGuardrailSensitiveInformationPolicyConfig.Builder)AIGuardrailSensitiveInformationPolicyConfig.builder().applyMutation(sensitiveInformationPolicyConfig)).build());
        }

        public Builder contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig var1);

        default public Builder contextualGroundingPolicyConfig(Consumer<AIGuardrailContextualGroundingPolicyConfig.Builder> contextualGroundingPolicyConfig) {
            return this.contextualGroundingPolicyConfig((AIGuardrailContextualGroundingPolicyConfig)((AIGuardrailContextualGroundingPolicyConfig.Builder)AIGuardrailContextualGroundingPolicyConfig.builder().applyMutation(contextualGroundingPolicyConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder modifiedTime(Instant var1);
    }
}

