/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AIAgentConfiguration;
import software.amazon.awssdk.services.qconnect.model.AIAgentType;
import software.amazon.awssdk.services.qconnect.model.Origin;
import software.amazon.awssdk.services.qconnect.model.Status;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.services.qconnect.model.VisibilityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AIAgentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AIAgentSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AIAgentSummary.getter(AIAgentSummary::name)).setter(AIAgentSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(AIAgentSummary.getter(AIAgentSummary::assistantId)).setter(AIAgentSummary.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()}).build();
    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantArn").getter(AIAgentSummary.getter(AIAgentSummary::assistantArn)).setter(AIAgentSummary.setter(Builder::assistantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()}).build();
    private static final SdkField<String> AI_AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentId").getter(AIAgentSummary.getter(AIAgentSummary::aiAgentId)).setter(AIAgentSummary.setter(Builder::aiAgentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AIAgentSummary.getter(AIAgentSummary::typeAsString)).setter(AIAgentSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> AI_AGENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentArn").getter(AIAgentSummary.getter(AIAgentSummary::aiAgentArn)).setter(AIAgentSummary.setter(Builder::aiAgentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentArn").build()}).build();
    private static final SdkField<Instant> MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedTime").getter(AIAgentSummary.getter(AIAgentSummary::modifiedTime)).setter(AIAgentSummary.setter(Builder::modifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTime").build()}).build();
    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visibilityStatus").getter(AIAgentSummary.getter(AIAgentSummary::visibilityStatusAsString)).setter(AIAgentSummary.setter(Builder::visibilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()}).build();
    private static final SdkField<AIAgentConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(AIAgentSummary.getter(AIAgentSummary::configuration)).setter(AIAgentSummary.setter(Builder::configuration)).constructor(AIAgentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("origin").getter(AIAgentSummary.getter(AIAgentSummary::originAsString)).setter(AIAgentSummary.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AIAgentSummary.getter(AIAgentSummary::description)).setter(AIAgentSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AIAgentSummary.getter(AIAgentSummary::statusAsString)).setter(AIAgentSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(AIAgentSummary.getter(AIAgentSummary::tags)).setter(AIAgentSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ASSISTANT_ID_FIELD, ASSISTANT_ARN_FIELD, AI_AGENT_ID_FIELD, TYPE_FIELD, AI_AGENT_ARN_FIELD, MODIFIED_TIME_FIELD, VISIBILITY_STATUS_FIELD, CONFIGURATION_FIELD, ORIGIN_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AIAgentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String assistantId;
    private final String assistantArn;
    private final String aiAgentId;
    private final String type;
    private final String aiAgentArn;
    private final Instant modifiedTime;
    private final String visibilityStatus;
    private final AIAgentConfiguration configuration;
    private final String origin;
    private final String description;
    private final String status;
    private final Map<String, String> tags;

    private AIAgentSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.assistantId = builder.assistantId;
        this.assistantArn = builder.assistantArn;
        this.aiAgentId = builder.aiAgentId;
        this.type = builder.type;
        this.aiAgentArn = builder.aiAgentArn;
        this.modifiedTime = builder.modifiedTime;
        this.visibilityStatus = builder.visibilityStatus;
        this.configuration = builder.configuration;
        this.origin = builder.origin;
        this.description = builder.description;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String assistantArn() {
        return this.assistantArn;
    }

    public final String aiAgentId() {
        return this.aiAgentId;
    }

    public final AIAgentType type() {
        return AIAgentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String aiAgentArn() {
        return this.aiAgentArn;
    }

    public final Instant modifiedTime() {
        return this.modifiedTime;
    }

    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(this.visibilityStatus);
    }

    public final String visibilityStatusAsString() {
        return this.visibilityStatus;
    }

    public final AIAgentConfiguration configuration() {
        return this.configuration;
    }

    public final Origin origin() {
        return Origin.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    public final String description() {
        return this.description;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIAgentSummary)) {
            return false;
        }
        AIAgentSummary other = (AIAgentSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.assistantArn(), other.assistantArn()) && Objects.equals(this.aiAgentId(), other.aiAgentId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.aiAgentArn(), other.aiAgentArn()) && Objects.equals(this.modifiedTime(), other.modifiedTime()) && Objects.equals(this.visibilityStatusAsString(), other.visibilityStatusAsString()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"AIAgentSummary").add("Name", (Object)this.name()).add("AssistantId", (Object)this.assistantId()).add("AssistantArn", (Object)this.assistantArn()).add("AiAgentId", (Object)this.aiAgentId()).add("Type", (Object)this.typeAsString()).add("AiAgentArn", (Object)this.aiAgentArn()).add("ModifiedTime", (Object)this.modifiedTime()).add("VisibilityStatus", (Object)this.visibilityStatusAsString()).add("Configuration", (Object)this.configuration()).add("Origin", (Object)this.originAsString()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "assistantArn": {
                return Optional.ofNullable(clazz.cast(this.assistantArn()));
            }
            case "aiAgentId": {
                return Optional.ofNullable(clazz.cast(this.aiAgentId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "aiAgentArn": {
                return Optional.ofNullable(clazz.cast(this.aiAgentArn()));
            }
            case "modifiedTime": {
                return Optional.ofNullable(clazz.cast(this.modifiedTime()));
            }
            case "visibilityStatus": {
                return Optional.ofNullable(clazz.cast(this.visibilityStatusAsString()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        map.put("aiAgentId", AI_AGENT_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("aiAgentArn", AI_AGENT_ARN_FIELD);
        map.put("modifiedTime", MODIFIED_TIME_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("origin", ORIGIN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIAgentSummary, T> g) {
        return obj -> g.apply((AIAgentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String assistantId;
        private String assistantArn;
        private String aiAgentId;
        private String type;
        private String aiAgentArn;
        private Instant modifiedTime;
        private String visibilityStatus;
        private AIAgentConfiguration configuration;
        private String origin;
        private String description;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AIAgentSummary model) {
            this.name(model.name);
            this.assistantId(model.assistantId);
            this.assistantArn(model.assistantArn);
            this.aiAgentId(model.aiAgentId);
            this.type(model.type);
            this.aiAgentArn(model.aiAgentArn);
            this.modifiedTime(model.modifiedTime);
            this.visibilityStatus(model.visibilityStatus);
            this.configuration(model.configuration);
            this.origin(model.origin);
            this.description(model.description);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAssistantArn() {
            return this.assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAiAgentId() {
            return this.aiAgentId;
        }

        public final void setAiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
        }

        @Override
        public final Builder aiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AIAgentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAiAgentArn() {
            return this.aiAgentArn;
        }

        public final void setAiAgentArn(String aiAgentArn) {
            this.aiAgentArn = aiAgentArn;
        }

        @Override
        public final Builder aiAgentArn(String aiAgentArn) {
            this.aiAgentArn = aiAgentArn;
            return this;
        }

        public final Instant getModifiedTime() {
            return this.modifiedTime;
        }

        public final void setModifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        @Override
        public final Builder modifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public final String getVisibilityStatus() {
            return this.visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final AIAgentConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AIAgentConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AIAgentConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public AIAgentSummary build() {
            return new AIAgentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AIAgentSummary> {
        public Builder name(String var1);

        public Builder assistantId(String var1);

        public Builder assistantArn(String var1);

        public Builder aiAgentId(String var1);

        public Builder type(String var1);

        public Builder type(AIAgentType var1);

        public Builder aiAgentArn(String var1);

        public Builder modifiedTime(Instant var1);

        public Builder visibilityStatus(String var1);

        public Builder visibilityStatus(VisibilityStatus var1);

        public Builder configuration(AIAgentConfiguration var1);

        default public Builder configuration(Consumer<AIAgentConfiguration.Builder> configuration) {
            return this.configuration((AIAgentConfiguration)((AIAgentConfiguration.Builder)AIAgentConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder origin(String var1);

        public Builder origin(Origin var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder tags(Map<String, String> var1);
    }
}

