/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AssistantSummary;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAssistantsResponse;

public class ListAssistantsIterable
implements SdkIterable<ListAssistantsResponse> {
    private final QConnectClient client;
    private final ListAssistantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssistantsIterable(QConnectClient client, ListAssistantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssistantsResponseFetcher();
    }

    public Iterator<ListAssistantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssistantSummary> assistantSummaries() {
        Function<ListAssistantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assistantSummaries() != null) {
                return response.assistantSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssistantsResponseFetcher
    implements SyncPageFetcher<ListAssistantsResponse> {
        private ListAssistantsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssistantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssistantsResponse nextPage(ListAssistantsResponse previousPage) {
            if (previousPage == null) {
                return ListAssistantsIterable.this.client.listAssistants(ListAssistantsIterable.this.firstRequest);
            }
            return ListAssistantsIterable.this.client.listAssistants((ListAssistantsRequest)((Object)ListAssistantsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

