/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AssistantAssociationSummary;
import software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAssistantAssociationsResponse;

public class ListAssistantAssociationsPublisher
implements SdkPublisher<ListAssistantAssociationsResponse> {
    private final QConnectAsyncClient client;
    private final ListAssistantAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssistantAssociationsPublisher(QConnectAsyncClient client, ListAssistantAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssistantAssociationsPublisher(QConnectAsyncClient client, ListAssistantAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssistantAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssistantAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssistantAssociationSummary> assistantAssociationSummaries() {
        Function<ListAssistantAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assistantAssociationSummaries() != null) {
                return response.assistantAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssistantAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssistantAssociationsResponseFetcher
    implements AsyncPageFetcher<ListAssistantAssociationsResponse> {
        private ListAssistantAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssistantAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssistantAssociationsResponse> nextPage(ListAssistantAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAssistantAssociationsPublisher.this.client.listAssistantAssociations(ListAssistantAssociationsPublisher.this.firstRequest);
            }
            return ListAssistantAssociationsPublisher.this.client.listAssistantAssociations((ListAssistantAssociationsRequest)((Object)ListAssistantAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

