/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.EmailHeader;
import software.amazon.awssdk.services.qconnect.model.EmailHeadersCopier;
import software.amazon.awssdk.services.qconnect.model.EmailMessageTemplateContentBody;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailMessageTemplateContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailMessageTemplateContent> {
    private static final SdkField<EmailMessageTemplateContentBody> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("body").getter(EmailMessageTemplateContent.getter(EmailMessageTemplateContent::body)).setter(EmailMessageTemplateContent.setter(Builder::body)).constructor(EmailMessageTemplateContentBody::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<List<EmailHeader>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("headers").getter(EmailMessageTemplateContent.getter(EmailMessageTemplateContent::headers)).setter(EmailMessageTemplateContent.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmailHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subject").getter(EmailMessageTemplateContent.getter(EmailMessageTemplateContent::subject)).setter(EmailMessageTemplateContent.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, HEADERS_FIELD, SUBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EmailMessageTemplateContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EmailMessageTemplateContentBody body;
    private final List<EmailHeader> headers;
    private final String subject;

    private EmailMessageTemplateContent(BuilderImpl builder) {
        this.body = builder.body;
        this.headers = builder.headers;
        this.subject = builder.subject;
    }

    public final EmailMessageTemplateContentBody body() {
        return this.body;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructList);
    }

    public final List<EmailHeader> headers() {
        return this.headers;
    }

    public final String subject() {
        return this.subject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailMessageTemplateContent)) {
            return false;
        }
        EmailMessageTemplateContent other = (EmailMessageTemplateContent)obj;
        return Objects.equals(this.body(), other.body()) && this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.subject(), other.subject());
    }

    public final String toString() {
        return ToString.builder((String)"EmailMessageTemplateContent").add("Body", (Object)this.body()).add("Headers", this.hasHeaders() ? this.headers() : null).add("Subject", (Object)(this.subject() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("body", BODY_FIELD);
        map.put("headers", HEADERS_FIELD);
        map.put("subject", SUBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailMessageTemplateContent, T> g) {
        return obj -> g.apply((EmailMessageTemplateContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EmailMessageTemplateContentBody body;
        private List<EmailHeader> headers = DefaultSdkAutoConstructList.getInstance();
        private String subject;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailMessageTemplateContent model) {
            this.body(model.body);
            this.headers(model.headers);
            this.subject(model.subject);
        }

        public final EmailMessageTemplateContentBody.Builder getBody() {
            return this.body != null ? this.body.toBuilder() : null;
        }

        public final void setBody(EmailMessageTemplateContentBody.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(EmailMessageTemplateContentBody body) {
            this.body = body;
            return this;
        }

        public final List<EmailHeader.Builder> getHeaders() {
            List<EmailHeader.Builder> result = EmailHeadersCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<EmailHeader.BuilderImpl> headers) {
            this.headers = EmailHeadersCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<EmailHeader> headers) {
            this.headers = EmailHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(EmailHeader ... headers) {
            this.headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<EmailHeader.Builder> ... headers) {
            this.headers(Stream.of(headers).map(c -> (EmailHeader)((EmailHeader.Builder)EmailHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public EmailMessageTemplateContent build() {
            return new EmailMessageTemplateContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailMessageTemplateContent> {
        public Builder body(EmailMessageTemplateContentBody var1);

        default public Builder body(Consumer<EmailMessageTemplateContentBody.Builder> body) {
            return this.body((EmailMessageTemplateContentBody)((EmailMessageTemplateContentBody.Builder)EmailMessageTemplateContentBody.builder().applyMutation(body)).build());
        }

        public Builder headers(Collection<EmailHeader> var1);

        public Builder headers(EmailHeader ... var1);

        public Builder headers(Consumer<EmailHeader.Builder> ... var1);

        public Builder subject(String var1);
    }
}

