/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AIPromptAPIFormat {
    ANTHROPIC_CLAUDE_MESSAGES("ANTHROPIC_CLAUDE_MESSAGES"),
    ANTHROPIC_CLAUDE_TEXT_COMPLETIONS("ANTHROPIC_CLAUDE_TEXT_COMPLETIONS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AIPromptAPIFormat> VALUE_MAP;
    private final String value;

    private AIPromptAPIFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AIPromptAPIFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AIPromptAPIFormat> knownValues() {
        EnumSet<AIPromptAPIFormat> knownValues = EnumSet.allOf(AIPromptAPIFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AIPromptAPIFormat.class, AIPromptAPIFormat::toString);
    }
}

