/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse;
import software.amazon.awssdk.services.qbusiness.model.WebExperience;

public class ListWebExperiencesIterable
implements SdkIterable<ListWebExperiencesResponse> {
    private final QBusinessClient client;
    private final ListWebExperiencesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWebExperiencesIterable(QBusinessClient client, ListWebExperiencesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWebExperiencesResponseFetcher();
    }

    public Iterator<ListWebExperiencesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WebExperience> webExperiences() {
        Function<ListWebExperiencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.webExperiences() != null) {
                return response.webExperiences().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWebExperiencesResponseFetcher
    implements SyncPageFetcher<ListWebExperiencesResponse> {
        private ListWebExperiencesResponseFetcher() {
        }

        public boolean hasNextPage(ListWebExperiencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWebExperiencesResponse nextPage(ListWebExperiencesResponse previousPage) {
            if (previousPage == null) {
                return ListWebExperiencesIterable.this.client.listWebExperiences(ListWebExperiencesIterable.this.firstRequest);
            }
            return ListWebExperiencesIterable.this.client.listWebExperiences((ListWebExperiencesRequest)((Object)ListWebExperiencesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

