/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.DataSourceSyncJob;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse;

public class ListDataSourceSyncJobsIterable
implements SdkIterable<ListDataSourceSyncJobsResponse> {
    private final QBusinessClient client;
    private final ListDataSourceSyncJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSourceSyncJobsIterable(QBusinessClient client, ListDataSourceSyncJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataSourceSyncJobsResponseFetcher();
    }

    public Iterator<ListDataSourceSyncJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSourceSyncJob> history() {
        Function<ListDataSourceSyncJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.history() != null) {
                return response.history().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataSourceSyncJobsResponseFetcher
    implements SyncPageFetcher<ListDataSourceSyncJobsResponse> {
        private ListDataSourceSyncJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSourceSyncJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataSourceSyncJobsResponse nextPage(ListDataSourceSyncJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourceSyncJobsIterable.this.client.listDataSourceSyncJobs(ListDataSourceSyncJobsIterable.this.firstRequest);
            }
            return ListDataSourceSyncJobsIterable.this.client.listDataSourceSyncJobs((ListDataSourceSyncJobsRequest)((Object)ListDataSourceSyncJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

