/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeBoostingLevel;
import software.amazon.awssdk.services.qbusiness.model.StringAttributeValueBoostingCopier;
import software.amazon.awssdk.services.qbusiness.model.StringAttributeValueBoostingLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StringAttributeBoostingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StringAttributeBoostingConfiguration> {
    private static final SdkField<String> BOOSTING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("boostingLevel").getter(StringAttributeBoostingConfiguration.getter(StringAttributeBoostingConfiguration::boostingLevelAsString)).setter(StringAttributeBoostingConfiguration.setter(Builder::boostingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingLevel").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTE_VALUE_BOOSTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributeValueBoosting").getter(StringAttributeBoostingConfiguration.getter(StringAttributeBoostingConfiguration::attributeValueBoostingAsStrings)).setter(StringAttributeBoostingConfiguration.setter(Builder::attributeValueBoostingWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeValueBoosting").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOSTING_LEVEL_FIELD, ATTRIBUTE_VALUE_BOOSTING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StringAttributeBoostingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String boostingLevel;
    private final Map<String, String> attributeValueBoosting;

    private StringAttributeBoostingConfiguration(BuilderImpl builder) {
        this.boostingLevel = builder.boostingLevel;
        this.attributeValueBoosting = builder.attributeValueBoosting;
    }

    public final DocumentAttributeBoostingLevel boostingLevel() {
        return DocumentAttributeBoostingLevel.fromValue(this.boostingLevel);
    }

    public final String boostingLevelAsString() {
        return this.boostingLevel;
    }

    public final Map<String, StringAttributeValueBoostingLevel> attributeValueBoosting() {
        return StringAttributeValueBoostingCopier.copyStringToEnum(this.attributeValueBoosting);
    }

    public final boolean hasAttributeValueBoosting() {
        return this.attributeValueBoosting != null && !(this.attributeValueBoosting instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributeValueBoostingAsStrings() {
        return this.attributeValueBoosting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boostingLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeValueBoosting() ? this.attributeValueBoostingAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringAttributeBoostingConfiguration)) {
            return false;
        }
        StringAttributeBoostingConfiguration other = (StringAttributeBoostingConfiguration)obj;
        return Objects.equals(this.boostingLevelAsString(), other.boostingLevelAsString()) && this.hasAttributeValueBoosting() == other.hasAttributeValueBoosting() && Objects.equals(this.attributeValueBoostingAsStrings(), other.attributeValueBoostingAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"StringAttributeBoostingConfiguration").add("BoostingLevel", (Object)this.boostingLevelAsString()).add("AttributeValueBoosting", this.hasAttributeValueBoosting() ? this.attributeValueBoostingAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "boostingLevel": {
                return Optional.ofNullable(clazz.cast(this.boostingLevelAsString()));
            }
            case "attributeValueBoosting": {
                return Optional.ofNullable(clazz.cast(this.attributeValueBoostingAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("boostingLevel", BOOSTING_LEVEL_FIELD);
        map.put("attributeValueBoosting", ATTRIBUTE_VALUE_BOOSTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringAttributeBoostingConfiguration, T> g) {
        return obj -> g.apply((StringAttributeBoostingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String boostingLevel;
        private Map<String, String> attributeValueBoosting = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StringAttributeBoostingConfiguration model) {
            this.boostingLevel(model.boostingLevel);
            this.attributeValueBoostingWithStrings(model.attributeValueBoosting);
        }

        public final String getBoostingLevel() {
            return this.boostingLevel;
        }

        public final void setBoostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
        }

        @Override
        public final Builder boostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
            return this;
        }

        @Override
        public final Builder boostingLevel(DocumentAttributeBoostingLevel boostingLevel) {
            this.boostingLevel(boostingLevel == null ? null : boostingLevel.toString());
            return this;
        }

        public final Map<String, String> getAttributeValueBoosting() {
            if (this.attributeValueBoosting instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributeValueBoosting;
        }

        public final void setAttributeValueBoosting(Map<String, String> attributeValueBoosting) {
            this.attributeValueBoosting = StringAttributeValueBoostingCopier.copy(attributeValueBoosting);
        }

        @Override
        public final Builder attributeValueBoostingWithStrings(Map<String, String> attributeValueBoosting) {
            this.attributeValueBoosting = StringAttributeValueBoostingCopier.copy(attributeValueBoosting);
            return this;
        }

        @Override
        public final Builder attributeValueBoosting(Map<String, StringAttributeValueBoostingLevel> attributeValueBoosting) {
            this.attributeValueBoosting = StringAttributeValueBoostingCopier.copyEnumToString(attributeValueBoosting);
            return this;
        }

        public StringAttributeBoostingConfiguration build() {
            return new StringAttributeBoostingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StringAttributeBoostingConfiguration> {
        public Builder boostingLevel(String var1);

        public Builder boostingLevel(DocumentAttributeBoostingLevel var1);

        public Builder attributeValueBoostingWithStrings(Map<String, String> var1);

        public Builder attributeValueBoosting(Map<String, StringAttributeValueBoostingLevel> var1);
    }
}

