/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.DataAccessorAuthenticationConfiguration;
import software.amazon.awssdk.services.qbusiness.model.DataAccessorAuthenticationType;
import software.amazon.awssdk.services.qbusiness.model.DataAccessorExternalIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataAccessorAuthenticationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataAccessorAuthenticationDetail> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authenticationType").getter(DataAccessorAuthenticationDetail.getter(DataAccessorAuthenticationDetail::authenticationTypeAsString)).setter(DataAccessorAuthenticationDetail.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build()}).build();
    private static final SdkField<DataAccessorAuthenticationConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authenticationConfiguration").getter(DataAccessorAuthenticationDetail.getter(DataAccessorAuthenticationDetail::authenticationConfiguration)).setter(DataAccessorAuthenticationDetail.setter(Builder::authenticationConfiguration)).constructor(DataAccessorAuthenticationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration").build()}).build();
    private static final SdkField<List<String>> EXTERNAL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("externalIds").getter(DataAccessorAuthenticationDetail.getter(DataAccessorAuthenticationDetail::externalIds)).setter(DataAccessorAuthenticationDetail.setter(Builder::externalIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, EXTERNAL_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataAccessorAuthenticationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String authenticationType;
    private final DataAccessorAuthenticationConfiguration authenticationConfiguration;
    private final List<String> externalIds;

    private DataAccessorAuthenticationDetail(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.externalIds = builder.externalIds;
    }

    public final DataAccessorAuthenticationType authenticationType() {
        return DataAccessorAuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final DataAccessorAuthenticationConfiguration authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public final boolean hasExternalIds() {
        return this.externalIds != null && !(this.externalIds instanceof SdkAutoConstructList);
    }

    public final List<String> externalIds() {
        return this.externalIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalIds() ? this.externalIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataAccessorAuthenticationDetail)) {
            return false;
        }
        DataAccessorAuthenticationDetail other = (DataAccessorAuthenticationDetail)obj;
        return Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration()) && this.hasExternalIds() == other.hasExternalIds() && Objects.equals(this.externalIds(), other.externalIds());
    }

    public final String toString() {
        return ToString.builder((String)"DataAccessorAuthenticationDetail").add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).add("ExternalIds", this.hasExternalIds() ? this.externalIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "authenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
            case "externalIds": {
                return Optional.ofNullable(clazz.cast(this.externalIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("authenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        map.put("externalIds", EXTERNAL_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataAccessorAuthenticationDetail, T> g) {
        return obj -> g.apply((DataAccessorAuthenticationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationType;
        private DataAccessorAuthenticationConfiguration authenticationConfiguration;
        private List<String> externalIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataAccessorAuthenticationDetail model) {
            this.authenticationType(model.authenticationType);
            this.authenticationConfiguration(model.authenticationConfiguration);
            this.externalIds(model.externalIds);
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(DataAccessorAuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final DataAccessorAuthenticationConfiguration.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(DataAccessorAuthenticationConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(DataAccessorAuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Collection<String> getExternalIds() {
            if (this.externalIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.externalIds;
        }

        public final void setExternalIds(Collection<String> externalIds) {
            this.externalIds = DataAccessorExternalIdsCopier.copy(externalIds);
        }

        @Override
        public final Builder externalIds(Collection<String> externalIds) {
            this.externalIds = DataAccessorExternalIdsCopier.copy(externalIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalIds(String ... externalIds) {
            this.externalIds(Arrays.asList(externalIds));
            return this;
        }

        public DataAccessorAuthenticationDetail build() {
            return new DataAccessorAuthenticationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataAccessorAuthenticationDetail> {
        public Builder authenticationType(String var1);

        public Builder authenticationType(DataAccessorAuthenticationType var1);

        public Builder authenticationConfiguration(DataAccessorAuthenticationConfiguration var1);

        default public Builder authenticationConfiguration(Consumer<DataAccessorAuthenticationConfiguration.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((DataAccessorAuthenticationConfiguration)((DataAccessorAuthenticationConfiguration.Builder)DataAccessorAuthenticationConfiguration.builder().applyMutation(authenticationConfiguration)).build());
        }

        public Builder externalIds(Collection<String> var1);

        public Builder externalIds(String ... var1);
    }
}

