/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginsResponse;
import software.amazon.awssdk.services.qbusiness.model.Plugin;

public class ListPluginsPublisher
implements SdkPublisher<ListPluginsResponse> {
    private final QBusinessAsyncClient client;
    private final ListPluginsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPluginsPublisher(QBusinessAsyncClient client, ListPluginsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPluginsPublisher(QBusinessAsyncClient client, ListPluginsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPluginsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPluginsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Plugin> plugins() {
        Function<ListPluginsResponse, Iterator> getIterator = response -> {
            if (response != null && response.plugins() != null) {
                return response.plugins().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPluginsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPluginsResponseFetcher
    implements AsyncPageFetcher<ListPluginsResponse> {
        private ListPluginsResponseFetcher() {
        }

        public boolean hasNextPage(ListPluginsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPluginsResponse> nextPage(ListPluginsResponse previousPage) {
            if (previousPage == null) {
                return ListPluginsPublisher.this.client.listPlugins(ListPluginsPublisher.this.firstRequest);
            }
            return ListPluginsPublisher.this.client.listPlugins((ListPluginsRequest)((Object)ListPluginsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

