/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataResponse;
import software.amazon.awssdk.services.qbusiness.model.PluginTypeMetadataSummary;

public class ListPluginTypeMetadataIterable
implements SdkIterable<ListPluginTypeMetadataResponse> {
    private final QBusinessClient client;
    private final ListPluginTypeMetadataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPluginTypeMetadataIterable(QBusinessClient client, ListPluginTypeMetadataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPluginTypeMetadataResponseFetcher();
    }

    public Iterator<ListPluginTypeMetadataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PluginTypeMetadataSummary> items() {
        Function<ListPluginTypeMetadataResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPluginTypeMetadataResponseFetcher
    implements SyncPageFetcher<ListPluginTypeMetadataResponse> {
        private ListPluginTypeMetadataResponseFetcher() {
        }

        public boolean hasNextPage(ListPluginTypeMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPluginTypeMetadataResponse nextPage(ListPluginTypeMetadataResponse previousPage) {
            if (previousPage == null) {
                return ListPluginTypeMetadataIterable.this.client.listPluginTypeMetadata(ListPluginTypeMetadataIterable.this.firstRequest);
            }
            return ListPluginTypeMetadataIterable.this.client.listPluginTypeMetadata((ListPluginTypeMetadataRequest)((Object)ListPluginTypeMetadataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

