/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.ActionConfiguration;
import software.amazon.awssdk.services.qbusiness.model.ActionConfigurationListCopier;
import software.amazon.awssdk.services.qbusiness.model.DataAccessorAuthenticationDetail;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataAccessorRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, UpdateDataAccessorRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(UpdateDataAccessorRequest.getter(UpdateDataAccessorRequest::applicationId)).setter(UpdateDataAccessorRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> DATA_ACCESSOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataAccessorId").getter(UpdateDataAccessorRequest.getter(UpdateDataAccessorRequest::dataAccessorId)).setter(UpdateDataAccessorRequest.setter(Builder::dataAccessorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataAccessorId").build()}).build();
    private static final SdkField<List<ActionConfiguration>> ACTION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionConfigurations").getter(UpdateDataAccessorRequest.getter(UpdateDataAccessorRequest::actionConfigurations)).setter(UpdateDataAccessorRequest.setter(Builder::actionConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataAccessorAuthenticationDetail> AUTHENTICATION_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authenticationDetail").getter(UpdateDataAccessorRequest.getter(UpdateDataAccessorRequest::authenticationDetail)).setter(UpdateDataAccessorRequest.setter(Builder::authenticationDetail)).constructor(DataAccessorAuthenticationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationDetail").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateDataAccessorRequest.getter(UpdateDataAccessorRequest::displayName)).setter(UpdateDataAccessorRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, DATA_ACCESSOR_ID_FIELD, ACTION_CONFIGURATIONS_FIELD, AUTHENTICATION_DETAIL_FIELD, DISPLAY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDataAccessorRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String dataAccessorId;
    private final List<ActionConfiguration> actionConfigurations;
    private final DataAccessorAuthenticationDetail authenticationDetail;
    private final String displayName;

    private UpdateDataAccessorRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.dataAccessorId = builder.dataAccessorId;
        this.actionConfigurations = builder.actionConfigurations;
        this.authenticationDetail = builder.authenticationDetail;
        this.displayName = builder.displayName;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String dataAccessorId() {
        return this.dataAccessorId;
    }

    public final boolean hasActionConfigurations() {
        return this.actionConfigurations != null && !(this.actionConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ActionConfiguration> actionConfigurations() {
        return this.actionConfigurations;
    }

    public final DataAccessorAuthenticationDetail authenticationDetail() {
        return this.authenticationDetail;
    }

    public final String displayName() {
        return this.displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionConfigurations() ? this.actionConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataAccessorRequest)) {
            return false;
        }
        UpdateDataAccessorRequest other = (UpdateDataAccessorRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.dataAccessorId(), other.dataAccessorId()) && this.hasActionConfigurations() == other.hasActionConfigurations() && Objects.equals(this.actionConfigurations(), other.actionConfigurations()) && Objects.equals(this.authenticationDetail(), other.authenticationDetail()) && Objects.equals(this.displayName(), other.displayName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataAccessorRequest").add("ApplicationId", (Object)this.applicationId()).add("DataAccessorId", (Object)this.dataAccessorId()).add("ActionConfigurations", this.hasActionConfigurations() ? this.actionConfigurations() : null).add("AuthenticationDetail", (Object)this.authenticationDetail()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "dataAccessorId": {
                return Optional.ofNullable(clazz.cast(this.dataAccessorId()));
            }
            case "actionConfigurations": {
                return Optional.ofNullable(clazz.cast(this.actionConfigurations()));
            }
            case "authenticationDetail": {
                return Optional.ofNullable(clazz.cast(this.authenticationDetail()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("dataAccessorId", DATA_ACCESSOR_ID_FIELD);
        map.put("actionConfigurations", ACTION_CONFIGURATIONS_FIELD);
        map.put("authenticationDetail", AUTHENTICATION_DETAIL_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataAccessorRequest, T> g) {
        return obj -> g.apply((UpdateDataAccessorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String dataAccessorId;
        private List<ActionConfiguration> actionConfigurations = DefaultSdkAutoConstructList.getInstance();
        private DataAccessorAuthenticationDetail authenticationDetail;
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataAccessorRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.dataAccessorId(model.dataAccessorId);
            this.actionConfigurations(model.actionConfigurations);
            this.authenticationDetail(model.authenticationDetail);
            this.displayName(model.displayName);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDataAccessorId() {
            return this.dataAccessorId;
        }

        public final void setDataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
        }

        @Override
        public final Builder dataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
            return this;
        }

        public final List<ActionConfiguration.Builder> getActionConfigurations() {
            List<ActionConfiguration.Builder> result = ActionConfigurationListCopier.copyToBuilder(this.actionConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionConfigurations(Collection<ActionConfiguration.BuilderImpl> actionConfigurations) {
            this.actionConfigurations = ActionConfigurationListCopier.copyFromBuilder(actionConfigurations);
        }

        @Override
        public final Builder actionConfigurations(Collection<ActionConfiguration> actionConfigurations) {
            this.actionConfigurations = ActionConfigurationListCopier.copy(actionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurations(ActionConfiguration ... actionConfigurations) {
            this.actionConfigurations(Arrays.asList(actionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurations(Consumer<ActionConfiguration.Builder> ... actionConfigurations) {
            this.actionConfigurations(Stream.of(actionConfigurations).map(c -> (ActionConfiguration)((ActionConfiguration.Builder)ActionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataAccessorAuthenticationDetail.Builder getAuthenticationDetail() {
            return this.authenticationDetail != null ? this.authenticationDetail.toBuilder() : null;
        }

        public final void setAuthenticationDetail(DataAccessorAuthenticationDetail.BuilderImpl authenticationDetail) {
            this.authenticationDetail = authenticationDetail != null ? authenticationDetail.build() : null;
        }

        @Override
        public final Builder authenticationDetail(DataAccessorAuthenticationDetail authenticationDetail) {
            this.authenticationDetail = authenticationDetail;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataAccessorRequest build() {
            return new UpdateDataAccessorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataAccessorRequest> {
        public Builder applicationId(String var1);

        public Builder dataAccessorId(String var1);

        public Builder actionConfigurations(Collection<ActionConfiguration> var1);

        public Builder actionConfigurations(ActionConfiguration ... var1);

        public Builder actionConfigurations(Consumer<ActionConfiguration.Builder> ... var1);

        public Builder authenticationDetail(DataAccessorAuthenticationDetail var1);

        default public Builder authenticationDetail(Consumer<DataAccessorAuthenticationDetail.Builder> authenticationDetail) {
            return this.authenticationDetail((DataAccessorAuthenticationDetail)((DataAccessorAuthenticationDetail.Builder)DataAccessorAuthenticationDetail.builder().applyMutation(authenticationDetail)).build());
        }

        public Builder displayName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

