/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StringAttributeValueBoostingLevel {
    LOW("LOW"),
    MEDIUM("MEDIUM"),
    HIGH("HIGH"),
    VERY_HIGH("VERY_HIGH"),
    ONE("ONE"),
    TWO("TWO"),
    THREE("THREE"),
    FOUR("FOUR"),
    FIVE("FIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StringAttributeValueBoostingLevel> VALUE_MAP;
    private final String value;

    private StringAttributeValueBoostingLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StringAttributeValueBoostingLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StringAttributeValueBoostingLevel> knownValues() {
        EnumSet<StringAttributeValueBoostingLevel> knownValues = EnumSet.allOf(StringAttributeValueBoostingLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StringAttributeValueBoostingLevel.class, StringAttributeValueBoostingLevel::toString);
    }
}

