/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.AudioSourceDetails;
import software.amazon.awssdk.services.qbusiness.model.ImageSourceDetails;
import software.amazon.awssdk.services.qbusiness.model.VideoSourceDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceDetails> {
    private static final SdkField<ImageSourceDetails> IMAGE_SOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageSourceDetails").getter(SourceDetails.getter(SourceDetails::imageSourceDetails)).setter(SourceDetails.setter(Builder::imageSourceDetails)).constructor(ImageSourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSourceDetails").build()}).build();
    private static final SdkField<AudioSourceDetails> AUDIO_SOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audioSourceDetails").getter(SourceDetails.getter(SourceDetails::audioSourceDetails)).setter(SourceDetails.setter(Builder::audioSourceDetails)).constructor(AudioSourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSourceDetails").build()}).build();
    private static final SdkField<VideoSourceDetails> VIDEO_SOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("videoSourceDetails").getter(SourceDetails.getter(SourceDetails::videoSourceDetails)).setter(SourceDetails.setter(Builder::videoSourceDetails)).constructor(VideoSourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSourceDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SOURCE_DETAILS_FIELD, AUDIO_SOURCE_DETAILS_FIELD, VIDEO_SOURCE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ImageSourceDetails imageSourceDetails;
    private final AudioSourceDetails audioSourceDetails;
    private final VideoSourceDetails videoSourceDetails;
    private final Type type;

    private SourceDetails(BuilderImpl builder) {
        this.imageSourceDetails = builder.imageSourceDetails;
        this.audioSourceDetails = builder.audioSourceDetails;
        this.videoSourceDetails = builder.videoSourceDetails;
        this.type = builder.type;
    }

    public final ImageSourceDetails imageSourceDetails() {
        return this.imageSourceDetails;
    }

    public final AudioSourceDetails audioSourceDetails() {
        return this.audioSourceDetails;
    }

    public final VideoSourceDetails videoSourceDetails() {
        return this.videoSourceDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoSourceDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDetails)) {
            return false;
        }
        SourceDetails other = (SourceDetails)obj;
        return Objects.equals(this.imageSourceDetails(), other.imageSourceDetails()) && Objects.equals(this.audioSourceDetails(), other.audioSourceDetails()) && Objects.equals(this.videoSourceDetails(), other.videoSourceDetails());
    }

    public final String toString() {
        return ToString.builder((String)"SourceDetails").add("ImageSourceDetails", (Object)this.imageSourceDetails()).add("AudioSourceDetails", (Object)this.audioSourceDetails()).add("VideoSourceDetails", (Object)this.videoSourceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageSourceDetails": {
                return Optional.ofNullable(clazz.cast(this.imageSourceDetails()));
            }
            case "audioSourceDetails": {
                return Optional.ofNullable(clazz.cast(this.audioSourceDetails()));
            }
            case "videoSourceDetails": {
                return Optional.ofNullable(clazz.cast(this.videoSourceDetails()));
            }
        }
        return Optional.empty();
    }

    public static SourceDetails fromImageSourceDetails(ImageSourceDetails imageSourceDetails) {
        return (SourceDetails)SourceDetails.builder().imageSourceDetails(imageSourceDetails).build();
    }

    public static SourceDetails fromImageSourceDetails(Consumer<ImageSourceDetails.Builder> imageSourceDetails) {
        ImageSourceDetails.Builder builder = ImageSourceDetails.builder();
        imageSourceDetails.accept(builder);
        return SourceDetails.fromImageSourceDetails((ImageSourceDetails)builder.build());
    }

    public static SourceDetails fromAudioSourceDetails(AudioSourceDetails audioSourceDetails) {
        return (SourceDetails)SourceDetails.builder().audioSourceDetails(audioSourceDetails).build();
    }

    public static SourceDetails fromAudioSourceDetails(Consumer<AudioSourceDetails.Builder> audioSourceDetails) {
        AudioSourceDetails.Builder builder = AudioSourceDetails.builder();
        audioSourceDetails.accept(builder);
        return SourceDetails.fromAudioSourceDetails((AudioSourceDetails)builder.build());
    }

    public static SourceDetails fromVideoSourceDetails(VideoSourceDetails videoSourceDetails) {
        return (SourceDetails)SourceDetails.builder().videoSourceDetails(videoSourceDetails).build();
    }

    public static SourceDetails fromVideoSourceDetails(Consumer<VideoSourceDetails.Builder> videoSourceDetails) {
        VideoSourceDetails.Builder builder = VideoSourceDetails.builder();
        videoSourceDetails.accept(builder);
        return SourceDetails.fromVideoSourceDetails((VideoSourceDetails)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("imageSourceDetails", IMAGE_SOURCE_DETAILS_FIELD);
        map.put("audioSourceDetails", AUDIO_SOURCE_DETAILS_FIELD);
        map.put("videoSourceDetails", VIDEO_SOURCE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceDetails, T> g) {
        return obj -> g.apply((SourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        IMAGE_SOURCE_DETAILS,
        AUDIO_SOURCE_DETAILS,
        VIDEO_SOURCE_DETAILS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ImageSourceDetails imageSourceDetails;
        private AudioSourceDetails audioSourceDetails;
        private VideoSourceDetails videoSourceDetails;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDetails model) {
            this.imageSourceDetails(model.imageSourceDetails);
            this.audioSourceDetails(model.audioSourceDetails);
            this.videoSourceDetails(model.videoSourceDetails);
        }

        public final ImageSourceDetails.Builder getImageSourceDetails() {
            return this.imageSourceDetails != null ? this.imageSourceDetails.toBuilder() : null;
        }

        public final void setImageSourceDetails(ImageSourceDetails.BuilderImpl imageSourceDetails) {
            ImageSourceDetails oldValue = this.imageSourceDetails;
            this.imageSourceDetails = imageSourceDetails != null ? imageSourceDetails.build() : null;
            this.handleUnionValueChange(Type.IMAGE_SOURCE_DETAILS, oldValue, this.imageSourceDetails);
        }

        @Override
        public final Builder imageSourceDetails(ImageSourceDetails imageSourceDetails) {
            ImageSourceDetails oldValue = this.imageSourceDetails;
            this.imageSourceDetails = imageSourceDetails;
            this.handleUnionValueChange(Type.IMAGE_SOURCE_DETAILS, oldValue, this.imageSourceDetails);
            return this;
        }

        public final AudioSourceDetails.Builder getAudioSourceDetails() {
            return this.audioSourceDetails != null ? this.audioSourceDetails.toBuilder() : null;
        }

        public final void setAudioSourceDetails(AudioSourceDetails.BuilderImpl audioSourceDetails) {
            AudioSourceDetails oldValue = this.audioSourceDetails;
            this.audioSourceDetails = audioSourceDetails != null ? audioSourceDetails.build() : null;
            this.handleUnionValueChange(Type.AUDIO_SOURCE_DETAILS, oldValue, this.audioSourceDetails);
        }

        @Override
        public final Builder audioSourceDetails(AudioSourceDetails audioSourceDetails) {
            AudioSourceDetails oldValue = this.audioSourceDetails;
            this.audioSourceDetails = audioSourceDetails;
            this.handleUnionValueChange(Type.AUDIO_SOURCE_DETAILS, oldValue, this.audioSourceDetails);
            return this;
        }

        public final VideoSourceDetails.Builder getVideoSourceDetails() {
            return this.videoSourceDetails != null ? this.videoSourceDetails.toBuilder() : null;
        }

        public final void setVideoSourceDetails(VideoSourceDetails.BuilderImpl videoSourceDetails) {
            VideoSourceDetails oldValue = this.videoSourceDetails;
            this.videoSourceDetails = videoSourceDetails != null ? videoSourceDetails.build() : null;
            this.handleUnionValueChange(Type.VIDEO_SOURCE_DETAILS, oldValue, this.videoSourceDetails);
        }

        @Override
        public final Builder videoSourceDetails(VideoSourceDetails videoSourceDetails) {
            VideoSourceDetails oldValue = this.videoSourceDetails;
            this.videoSourceDetails = videoSourceDetails;
            this.handleUnionValueChange(Type.VIDEO_SOURCE_DETAILS, oldValue, this.videoSourceDetails);
            return this;
        }

        public SourceDetails build() {
            return new SourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceDetails> {
        public Builder imageSourceDetails(ImageSourceDetails var1);

        default public Builder imageSourceDetails(Consumer<ImageSourceDetails.Builder> imageSourceDetails) {
            return this.imageSourceDetails((ImageSourceDetails)((ImageSourceDetails.Builder)ImageSourceDetails.builder().applyMutation(imageSourceDetails)).build());
        }

        public Builder audioSourceDetails(AudioSourceDetails var1);

        default public Builder audioSourceDetails(Consumer<AudioSourceDetails.Builder> audioSourceDetails) {
            return this.audioSourceDetails((AudioSourceDetails)((AudioSourceDetails.Builder)AudioSourceDetails.builder().applyMutation(audioSourceDetails)).build());
        }

        public Builder videoSourceDetails(VideoSourceDetails var1);

        default public Builder videoSourceDetails(Consumer<VideoSourceDetails.Builder> videoSourceDetails) {
            return this.videoSourceDetails((VideoSourceDetails)((VideoSourceDetails.Builder)VideoSourceDetails.builder().applyMutation(videoSourceDetails)).build());
        }
    }
}

