/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResponseScope {
    ENTERPRISE_CONTENT_ONLY("ENTERPRISE_CONTENT_ONLY"),
    EXTENDED_KNOWLEDGE_ENABLED("EXTENDED_KNOWLEDGE_ENABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResponseScope> VALUE_MAP;
    private final String value;

    private ResponseScope(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResponseScope fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResponseScope> knownValues() {
        EnumSet<ResponseScope> knownValues = EnumSet.allOf(ResponseScope.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResponseScope.class, ResponseScope::toString);
    }
}

