/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenIDConnectProviderConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenIDConnectProviderConfiguration> {
    private static final SdkField<String> SECRETS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretsArn").getter(OpenIDConnectProviderConfiguration.getter(OpenIDConnectProviderConfiguration::secretsArn)).setter(OpenIDConnectProviderConfiguration.setter(Builder::secretsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsArn").build()}).build();
    private static final SdkField<String> SECRETS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretsRole").getter(OpenIDConnectProviderConfiguration.getter(OpenIDConnectProviderConfiguration::secretsRole)).setter(OpenIDConnectProviderConfiguration.setter(Builder::secretsRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRETS_ARN_FIELD, SECRETS_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpenIDConnectProviderConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String secretsArn;
    private final String secretsRole;

    private OpenIDConnectProviderConfiguration(BuilderImpl builder) {
        this.secretsArn = builder.secretsArn;
        this.secretsRole = builder.secretsRole;
    }

    public final String secretsArn() {
        return this.secretsArn;
    }

    public final String secretsRole() {
        return this.secretsRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIDConnectProviderConfiguration)) {
            return false;
        }
        OpenIDConnectProviderConfiguration other = (OpenIDConnectProviderConfiguration)obj;
        return Objects.equals(this.secretsArn(), other.secretsArn()) && Objects.equals(this.secretsRole(), other.secretsRole());
    }

    public final String toString() {
        return ToString.builder((String)"OpenIDConnectProviderConfiguration").add("SecretsArn", (Object)this.secretsArn()).add("SecretsRole", (Object)this.secretsRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "secretsArn": {
                return Optional.ofNullable(clazz.cast(this.secretsArn()));
            }
            case "secretsRole": {
                return Optional.ofNullable(clazz.cast(this.secretsRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("secretsArn", SECRETS_ARN_FIELD);
        map.put("secretsRole", SECRETS_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenIDConnectProviderConfiguration, T> g) {
        return obj -> g.apply((OpenIDConnectProviderConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String secretsArn;
        private String secretsRole;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenIDConnectProviderConfiguration model) {
            this.secretsArn(model.secretsArn);
            this.secretsRole(model.secretsRole);
        }

        public final String getSecretsArn() {
            return this.secretsArn;
        }

        public final void setSecretsArn(String secretsArn) {
            this.secretsArn = secretsArn;
        }

        @Override
        public final Builder secretsArn(String secretsArn) {
            this.secretsArn = secretsArn;
            return this;
        }

        public final String getSecretsRole() {
            return this.secretsRole;
        }

        public final void setSecretsRole(String secretsRole) {
            this.secretsRole = secretsRole;
        }

        @Override
        public final Builder secretsRole(String secretsRole) {
            this.secretsRole = secretsRole;
            return this;
        }

        public OpenIDConnectProviderConfiguration build() {
            return new OpenIDConnectProviderConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenIDConnectProviderConfiguration> {
        public Builder secretsArn(String var1);

        public Builder secretsRole(String var1);
    }
}

