/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.services.qbusiness.model.Retriever;
import software.amazon.awssdk.services.qbusiness.model.RetrieversCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRetrieversResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, ListRetrieversResponse> {
    private static final SdkField<List<Retriever>> RETRIEVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("retrievers").getter(ListRetrieversResponse.getter(ListRetrieversResponse::retrievers)).setter(ListRetrieversResponse.setter(Builder::retrievers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Retriever::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRetrieversResponse.getter(ListRetrieversResponse::nextToken)).setter(ListRetrieversResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRetrieversResponse.memberNameToFieldInitializer();
    private final List<Retriever> retrievers;
    private final String nextToken;

    private ListRetrieversResponse(BuilderImpl builder) {
        super(builder);
        this.retrievers = builder.retrievers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRetrievers() {
        return this.retrievers != null && !(this.retrievers instanceof SdkAutoConstructList);
    }

    public final List<Retriever> retrievers() {
        return this.retrievers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetrievers() ? this.retrievers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetrieversResponse)) {
            return false;
        }
        ListRetrieversResponse other = (ListRetrieversResponse)((Object)obj);
        return this.hasRetrievers() == other.hasRetrievers() && Objects.equals(this.retrievers(), other.retrievers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRetrieversResponse").add("Retrievers", this.hasRetrievers() ? this.retrievers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "retrievers": {
                return Optional.ofNullable(clazz.cast(this.retrievers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("retrievers", RETRIEVERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRetrieversResponse, T> g) {
        return obj -> g.apply((ListRetrieversResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private List<Retriever> retrievers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetrieversResponse model) {
            super(model);
            this.retrievers(model.retrievers);
            this.nextToken(model.nextToken);
        }

        public final List<Retriever.Builder> getRetrievers() {
            List<Retriever.Builder> result = RetrieversCopier.copyToBuilder(this.retrievers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetrievers(Collection<Retriever.BuilderImpl> retrievers) {
            this.retrievers = RetrieversCopier.copyFromBuilder(retrievers);
        }

        @Override
        public final Builder retrievers(Collection<Retriever> retrievers) {
            this.retrievers = RetrieversCopier.copy(retrievers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievers(Retriever ... retrievers) {
            this.retrievers(Arrays.asList(retrievers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievers(Consumer<Retriever.Builder> ... retrievers) {
            this.retrievers(Stream.of(retrievers).map(c -> (Retriever)((Retriever.Builder)Retriever.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRetrieversResponse build() {
            return new ListRetrieversResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRetrieversResponse> {
        public Builder retrievers(Collection<Retriever> var1);

        public Builder retrievers(Retriever ... var1);

        public Builder retrievers(Consumer<Retriever.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

