/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.DocumentAclCondition;
import software.amazon.awssdk.services.qbusiness.model.DocumentAclConditionsCopier;
import software.amazon.awssdk.services.qbusiness.model.MemberRelation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentAclMembership
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentAclMembership> {
    private static final SdkField<String> MEMBER_RELATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memberRelation").getter(DocumentAclMembership.getter(DocumentAclMembership::memberRelationAsString)).setter(DocumentAclMembership.setter(Builder::memberRelation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberRelation").build()}).build();
    private static final SdkField<List<DocumentAclCondition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conditions").getter(DocumentAclMembership.getter(DocumentAclMembership::conditions)).setter(DocumentAclMembership.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAclCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_RELATION_FIELD, CONDITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentAclMembership.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String memberRelation;
    private final List<DocumentAclCondition> conditions;

    private DocumentAclMembership(BuilderImpl builder) {
        this.memberRelation = builder.memberRelation;
        this.conditions = builder.conditions;
    }

    public final MemberRelation memberRelation() {
        return MemberRelation.fromValue(this.memberRelation);
    }

    public final String memberRelationAsString() {
        return this.memberRelation;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<DocumentAclCondition> conditions() {
        return this.conditions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memberRelationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAclMembership)) {
            return false;
        }
        DocumentAclMembership other = (DocumentAclMembership)obj;
        return Objects.equals(this.memberRelationAsString(), other.memberRelationAsString()) && this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentAclMembership").add("MemberRelation", (Object)this.memberRelationAsString()).add("Conditions", this.hasConditions() ? this.conditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memberRelation": {
                return Optional.ofNullable(clazz.cast(this.memberRelationAsString()));
            }
            case "conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberRelation", MEMBER_RELATION_FIELD);
        map.put("conditions", CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentAclMembership, T> g) {
        return obj -> g.apply((DocumentAclMembership)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memberRelation;
        private List<DocumentAclCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAclMembership model) {
            this.memberRelation(model.memberRelation);
            this.conditions(model.conditions);
        }

        public final String getMemberRelation() {
            return this.memberRelation;
        }

        public final void setMemberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
        }

        @Override
        public final Builder memberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
            return this;
        }

        @Override
        public final Builder memberRelation(MemberRelation memberRelation) {
            this.memberRelation(memberRelation == null ? null : memberRelation.toString());
            return this;
        }

        public final List<DocumentAclCondition.Builder> getConditions() {
            List<DocumentAclCondition.Builder> result = DocumentAclConditionsCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<DocumentAclCondition.BuilderImpl> conditions) {
            this.conditions = DocumentAclConditionsCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<DocumentAclCondition> conditions) {
            this.conditions = DocumentAclConditionsCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(DocumentAclCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<DocumentAclCondition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (DocumentAclCondition)((DocumentAclCondition.Builder)DocumentAclCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DocumentAclMembership build() {
            return new DocumentAclMembership(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentAclMembership> {
        public Builder memberRelation(String var1);

        public Builder memberRelation(MemberRelation var1);

        public Builder conditions(Collection<DocumentAclCondition> var1);

        public Builder conditions(DocumentAclCondition ... var1);

        public Builder conditions(Consumer<DocumentAclCondition.Builder> ... var1);
    }
}

