/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.AttributeFilter;
import software.amazon.awssdk.services.qbusiness.model.ChatInputStream;
import software.amazon.awssdk.services.qbusiness.model.ChatMode;
import software.amazon.awssdk.services.qbusiness.model.ChatModeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigurationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationEvent>,
ChatInputStream {
    private static final SdkField<String> CHAT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("chatMode").getter(ConfigurationEvent.getter(ConfigurationEvent::chatModeAsString)).setter(ConfigurationEvent.setter(Builder::chatMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatMode").build()}).build();
    private static final SdkField<ChatModeConfiguration> CHAT_MODE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("chatModeConfiguration").getter(ConfigurationEvent.getter(ConfigurationEvent::chatModeConfiguration)).setter(ConfigurationEvent.setter(Builder::chatModeConfiguration)).constructor(ChatModeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatModeConfiguration").build()}).build();
    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attributeFilter").getter(ConfigurationEvent.getter(ConfigurationEvent::attributeFilter)).setter(ConfigurationEvent.setter(Builder::attributeFilter)).constructor(AttributeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAT_MODE_FIELD, CHAT_MODE_CONFIGURATION_FIELD, ATTRIBUTE_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String chatMode;
    private final ChatModeConfiguration chatModeConfiguration;
    private final AttributeFilter attributeFilter;

    protected ConfigurationEvent(BuilderImpl builder) {
        this.chatMode = builder.chatMode;
        this.chatModeConfiguration = builder.chatModeConfiguration;
        this.attributeFilter = builder.attributeFilter;
    }

    public final ChatMode chatMode() {
        return ChatMode.fromValue(this.chatMode);
    }

    public final String chatModeAsString() {
        return this.chatMode;
    }

    public final ChatModeConfiguration chatModeConfiguration() {
        return this.chatModeConfiguration;
    }

    public final AttributeFilter attributeFilter() {
        return this.attributeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.chatModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatModeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationEvent)) {
            return false;
        }
        ConfigurationEvent other = (ConfigurationEvent)obj;
        return Objects.equals(this.chatModeAsString(), other.chatModeAsString()) && Objects.equals(this.chatModeConfiguration(), other.chatModeConfiguration()) && Objects.equals(this.attributeFilter(), other.attributeFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationEvent").add("ChatMode", (Object)this.chatModeAsString()).add("ChatModeConfiguration", (Object)this.chatModeConfiguration()).add("AttributeFilter", (Object)this.attributeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "chatMode": {
                return Optional.ofNullable(clazz.cast(this.chatModeAsString()));
            }
            case "chatModeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chatModeConfiguration()));
            }
            case "attributeFilter": {
                return Optional.ofNullable(clazz.cast(this.attributeFilter()));
            }
        }
        return Optional.empty();
    }

    public final ConfigurationEvent copy(Consumer<? super Builder> modifier) {
        return (ConfigurationEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("chatMode", CHAT_MODE_FIELD);
        map.put("chatModeConfiguration", CHAT_MODE_CONFIGURATION_FIELD);
        map.put("attributeFilter", ATTRIBUTE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationEvent, T> g) {
        return obj -> g.apply((ConfigurationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    protected static class BuilderImpl
    implements Builder {
        private String chatMode;
        private ChatModeConfiguration chatModeConfiguration;
        private AttributeFilter attributeFilter;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ConfigurationEvent model) {
            this.chatMode(model.chatMode);
            this.chatModeConfiguration(model.chatModeConfiguration);
            this.attributeFilter(model.attributeFilter);
        }

        public final String getChatMode() {
            return this.chatMode;
        }

        public final void setChatMode(String chatMode) {
            this.chatMode = chatMode;
        }

        @Override
        public final Builder chatMode(String chatMode) {
            this.chatMode = chatMode;
            return this;
        }

        @Override
        public final Builder chatMode(ChatMode chatMode) {
            this.chatMode(chatMode == null ? null : chatMode.toString());
            return this;
        }

        public final ChatModeConfiguration.Builder getChatModeConfiguration() {
            return this.chatModeConfiguration != null ? this.chatModeConfiguration.toBuilder() : null;
        }

        public final void setChatModeConfiguration(ChatModeConfiguration.BuilderImpl chatModeConfiguration) {
            this.chatModeConfiguration = chatModeConfiguration != null ? chatModeConfiguration.build() : null;
        }

        @Override
        public final Builder chatModeConfiguration(ChatModeConfiguration chatModeConfiguration) {
            this.chatModeConfiguration = chatModeConfiguration;
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return this.attributeFilter != null ? this.attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public ConfigurationEvent build() {
            return new ConfigurationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationEvent> {
        public Builder chatMode(String var1);

        public Builder chatMode(ChatMode var1);

        public Builder chatModeConfiguration(ChatModeConfiguration var1);

        default public Builder chatModeConfiguration(Consumer<ChatModeConfiguration.Builder> chatModeConfiguration) {
            return this.chatModeConfiguration((ChatModeConfiguration)((ChatModeConfiguration.Builder)ChatModeConfiguration.builder().applyMutation(chatModeConfiguration)).build());
        }

        public Builder attributeFilter(AttributeFilter var1);

        default public Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return this.attributeFilter((AttributeFilter)((AttributeFilter.Builder)AttributeFilter.builder().applyMutation(attributeFilter)).build());
        }
    }
}

