/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.services.qbusiness.model.ActionReviewEvent;
import software.amazon.awssdk.services.qbusiness.model.AuthChallengeRequestEvent;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseHandler;
import software.amazon.awssdk.services.qbusiness.model.FailedAttachmentEvent;
import software.amazon.awssdk.services.qbusiness.model.MetadataEvent;
import software.amazon.awssdk.services.qbusiness.model.TextOutputEvent;
import software.amazon.awssdk.services.qbusiness.model.chatoutputstream.DefaultActionReviewEvent;
import software.amazon.awssdk.services.qbusiness.model.chatoutputstream.DefaultAuthChallengeRequestEvent;
import software.amazon.awssdk.services.qbusiness.model.chatoutputstream.DefaultFailedAttachmentEvent;
import software.amazon.awssdk.services.qbusiness.model.chatoutputstream.DefaultMetadataEvent;
import software.amazon.awssdk.services.qbusiness.model.chatoutputstream.DefaultTextEvent;
import software.amazon.awssdk.utils.internal.EnumUtils;

@SdkPublicApi
public interface ChatOutputStream
extends SdkPojo {
    public static final ChatOutputStream UNKNOWN = new ChatOutputStream(){

        public List<SdkField<?>> sdkFields() {
            return Collections.emptyList();
        }

        @Override
        public void accept(ChatResponseHandler.Visitor visitor) {
            visitor.visitDefault(this);
        }
    };

    public static TextOutputEvent.Builder textEventBuilder() {
        return DefaultTextEvent.builder();
    }

    public static MetadataEvent.Builder metadataEventBuilder() {
        return DefaultMetadataEvent.builder();
    }

    public static ActionReviewEvent.Builder actionReviewEventBuilder() {
        return DefaultActionReviewEvent.builder();
    }

    public static FailedAttachmentEvent.Builder failedAttachmentEventBuilder() {
        return DefaultFailedAttachmentEvent.builder();
    }

    public static AuthChallengeRequestEvent.Builder authChallengeRequestEventBuilder() {
        return DefaultAuthChallengeRequestEvent.builder();
    }

    default public EventType sdkEventType() {
        return EventType.UNKNOWN_TO_SDK_VERSION;
    }

    public void accept(ChatResponseHandler.Visitor var1);

    public static enum EventType {
        TEXT_EVENT("textEvent"),
        METADATA_EVENT("metadataEvent"),
        ACTION_REVIEW_EVENT("actionReviewEvent"),
        FAILED_ATTACHMENT_EVENT("failedAttachmentEvent"),
        AUTH_CHALLENGE_REQUEST_EVENT("authChallengeRequestEvent"),
        UNKNOWN_TO_SDK_VERSION(null);

        private static final Map<String, EventType> VALUE_MAP;
        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventType fromValue(String value) {
            if (value == null) {
                return null;
            }
            return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
        }

        public static Set<EventType> knownValues() {
            EnumSet<EventType> knownValues = EnumSet.allOf(EventType.class);
            knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
            return knownValues;
        }

        static {
            VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);
        }
    }
}

