/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.AttachmentStatus;
import software.amazon.awssdk.services.qbusiness.model.CopyFromSource;
import software.amazon.awssdk.services.qbusiness.model.ErrorDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Attachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Attachment> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentId").getter(Attachment.getter(Attachment::attachmentId)).setter(Attachment.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentId").build()}).build();
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationId").getter(Attachment.getter(Attachment::conversationId)).setter(Attachment.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Attachment.getter(Attachment::name)).setter(Attachment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<CopyFromSource> COPY_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("copyFrom").getter(Attachment.getter(Attachment::copyFrom)).setter(Attachment.setter(Builder::copyFrom)).constructor(CopyFromSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyFrom").build()}).build();
    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileType").getter(Attachment.getter(Attachment::fileType)).setter(Attachment.setter(Builder::fileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileType").build()}).build();
    private static final SdkField<Integer> FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("fileSize").getter(Attachment.getter(Attachment::fileSize)).setter(Attachment.setter(Builder::fileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSize").build()}).build();
    private static final SdkField<String> MD5_CHKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("md5chksum").getter(Attachment.getter(Attachment::md5chksum)).setter(Attachment.setter(Builder::md5chksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("md5chksum").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Attachment.getter(Attachment::createdAt)).setter(Attachment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Attachment.getter(Attachment::statusAsString)).setter(Attachment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(Attachment.getter(Attachment::error)).setter(Attachment.setter(Builder::error)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD, CONVERSATION_ID_FIELD, NAME_FIELD, COPY_FROM_FIELD, FILE_TYPE_FIELD, FILE_SIZE_FIELD, MD5_CHKSUM_FIELD, CREATED_AT_FIELD, STATUS_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Attachment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attachmentId;
    private final String conversationId;
    private final String name;
    private final CopyFromSource copyFrom;
    private final String fileType;
    private final Integer fileSize;
    private final String md5chksum;
    private final Instant createdAt;
    private final String status;
    private final ErrorDetail error;

    private Attachment(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.conversationId = builder.conversationId;
        this.name = builder.name;
        this.copyFrom = builder.copyFrom;
        this.fileType = builder.fileType;
        this.fileSize = builder.fileSize;
        this.md5chksum = builder.md5chksum;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.error = builder.error;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final String name() {
        return this.name;
    }

    public final CopyFromSource copyFrom() {
        return this.copyFrom;
    }

    public final String fileType() {
        return this.fileType;
    }

    public final Integer fileSize() {
        return this.fileSize;
    }

    public final String md5chksum() {
        return this.md5chksum;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final AttachmentStatus status() {
        return AttachmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ErrorDetail error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileType());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.md5chksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.conversationId(), other.conversationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.copyFrom(), other.copyFrom()) && Objects.equals(this.fileType(), other.fileType()) && Objects.equals(this.fileSize(), other.fileSize()) && Objects.equals(this.md5chksum(), other.md5chksum()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"Attachment").add("AttachmentId", (Object)this.attachmentId()).add("ConversationId", (Object)this.conversationId()).add("Name", (Object)this.name()).add("CopyFrom", (Object)this.copyFrom()).add("FileType", (Object)this.fileType()).add("FileSize", (Object)this.fileSize()).add("Md5chksum", (Object)this.md5chksum()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "conversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "copyFrom": {
                return Optional.ofNullable(clazz.cast(this.copyFrom()));
            }
            case "fileType": {
                return Optional.ofNullable(clazz.cast(this.fileType()));
            }
            case "fileSize": {
                return Optional.ofNullable(clazz.cast(this.fileSize()));
            }
            case "md5chksum": {
                return Optional.ofNullable(clazz.cast(this.md5chksum()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attachmentId", ATTACHMENT_ID_FIELD);
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("copyFrom", COPY_FROM_FIELD);
        map.put("fileType", FILE_TYPE_FIELD);
        map.put("fileSize", FILE_SIZE_FIELD);
        map.put("md5chksum", MD5_CHKSUM_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Attachment, T> g) {
        return obj -> g.apply((Attachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachmentId;
        private String conversationId;
        private String name;
        private CopyFromSource copyFrom;
        private String fileType;
        private Integer fileSize;
        private String md5chksum;
        private Instant createdAt;
        private String status;
        private ErrorDetail error;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            this.attachmentId(model.attachmentId);
            this.conversationId(model.conversationId);
            this.name(model.name);
            this.copyFrom(model.copyFrom);
            this.fileType(model.fileType);
            this.fileSize(model.fileSize);
            this.md5chksum(model.md5chksum);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.error(model.error);
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CopyFromSource.Builder getCopyFrom() {
            return this.copyFrom != null ? this.copyFrom.toBuilder() : null;
        }

        public final void setCopyFrom(CopyFromSource.BuilderImpl copyFrom) {
            this.copyFrom = copyFrom != null ? copyFrom.build() : null;
        }

        @Override
        public final Builder copyFrom(CopyFromSource copyFrom) {
            this.copyFrom = copyFrom;
            return this;
        }

        public final String getFileType() {
            return this.fileType;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public final Integer getFileSize() {
            return this.fileSize;
        }

        public final void setFileSize(Integer fileSize) {
            this.fileSize = fileSize;
        }

        @Override
        public final Builder fileSize(Integer fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final String getMd5chksum() {
            return this.md5chksum;
        }

        public final void setMd5chksum(String md5chksum) {
            this.md5chksum = md5chksum;
        }

        @Override
        public final Builder md5chksum(String md5chksum) {
            this.md5chksum = md5chksum;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public Attachment build() {
            return new Attachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Attachment> {
        public Builder attachmentId(String var1);

        public Builder conversationId(String var1);

        public Builder name(String var1);

        public Builder copyFrom(CopyFromSource var1);

        default public Builder copyFrom(Consumer<CopyFromSource.Builder> copyFrom) {
            return this.copyFrom((CopyFromSource)((CopyFromSource.Builder)CopyFromSource.builder().applyMutation(copyFrom)).build());
        }

        public Builder fileType(String var1);

        public Builder fileSize(Integer var1);

        public Builder md5chksum(String var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(AttachmentStatus var1);

        public Builder error(ErrorDetail var1);

        default public Builder error(Consumer<ErrorDetail.Builder> error) {
            return this.error((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(error)).build());
        }
    }
}

