/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.ApplicationStatus;
import software.amazon.awssdk.services.qbusiness.model.AppliedAttachmentsConfiguration;
import software.amazon.awssdk.services.qbusiness.model.AutoSubscriptionConfiguration;
import software.amazon.awssdk.services.qbusiness.model.ClientIdsForOIDCCopier;
import software.amazon.awssdk.services.qbusiness.model.EncryptionConfiguration;
import software.amazon.awssdk.services.qbusiness.model.ErrorDetail;
import software.amazon.awssdk.services.qbusiness.model.IdentityType;
import software.amazon.awssdk.services.qbusiness.model.PersonalizationConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QAppsConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.services.qbusiness.model.QuickSightConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, GetApplicationResponse> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetApplicationResponse.getter(GetApplicationResponse::displayName)).setter(GetApplicationResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(GetApplicationResponse.getter(GetApplicationResponse::applicationId)).setter(GetApplicationResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationArn").getter(GetApplicationResponse.getter(GetApplicationResponse::applicationArn)).setter(GetApplicationResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()}).build();
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityType").getter(GetApplicationResponse.getter(GetApplicationResponse::identityTypeAsString)).setter(GetApplicationResponse.setter(Builder::identityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityType").build()}).build();
    private static final SdkField<String> IAM_IDENTITY_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamIdentityProviderArn").getter(GetApplicationResponse.getter(GetApplicationResponse::iamIdentityProviderArn)).setter(GetApplicationResponse.setter(Builder::iamIdentityProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityProviderArn").build()}).build();
    private static final SdkField<String> IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityCenterApplicationArn").getter(GetApplicationResponse.getter(GetApplicationResponse::identityCenterApplicationArn)).setter(GetApplicationResponse.setter(Builder::identityCenterApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityCenterApplicationArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetApplicationResponse.getter(GetApplicationResponse::roleArn)).setter(GetApplicationResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetApplicationResponse.getter(GetApplicationResponse::statusAsString)).setter(GetApplicationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetApplicationResponse.getter(GetApplicationResponse::description)).setter(GetApplicationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(GetApplicationResponse.getter(GetApplicationResponse::encryptionConfiguration)).setter(GetApplicationResponse.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetApplicationResponse.getter(GetApplicationResponse::createdAt)).setter(GetApplicationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetApplicationResponse.getter(GetApplicationResponse::updatedAt)).setter(GetApplicationResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(GetApplicationResponse.getter(GetApplicationResponse::error)).setter(GetApplicationResponse.setter(Builder::error)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<AppliedAttachmentsConfiguration> ATTACHMENTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attachmentsConfiguration").getter(GetApplicationResponse.getter(GetApplicationResponse::attachmentsConfiguration)).setter(GetApplicationResponse.setter(Builder::attachmentsConfiguration)).constructor(AppliedAttachmentsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentsConfiguration").build()}).build();
    private static final SdkField<QAppsConfiguration> Q_APPS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("qAppsConfiguration").getter(GetApplicationResponse.getter(GetApplicationResponse::qAppsConfiguration)).setter(GetApplicationResponse.setter(Builder::qAppsConfiguration)).constructor(QAppsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qAppsConfiguration").build()}).build();
    private static final SdkField<PersonalizationConfiguration> PERSONALIZATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("personalizationConfiguration").getter(GetApplicationResponse.getter(GetApplicationResponse::personalizationConfiguration)).setter(GetApplicationResponse.setter(Builder::personalizationConfiguration)).constructor(PersonalizationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personalizationConfiguration").build()}).build();
    private static final SdkField<AutoSubscriptionConfiguration> AUTO_SUBSCRIPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoSubscriptionConfiguration").getter(GetApplicationResponse.getter(GetApplicationResponse::autoSubscriptionConfiguration)).setter(GetApplicationResponse.setter(Builder::autoSubscriptionConfiguration)).constructor(AutoSubscriptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSubscriptionConfiguration").build()}).build();
    private static final SdkField<List<String>> CLIENT_IDS_FOR_OIDC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clientIdsForOIDC").getter(GetApplicationResponse.getter(GetApplicationResponse::clientIdsForOIDC)).setter(GetApplicationResponse.setter(Builder::clientIdsForOIDC)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIdsForOIDC").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<QuickSightConfiguration> QUICK_SIGHT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("quickSightConfiguration").getter(GetApplicationResponse.getter(GetApplicationResponse::quickSightConfiguration)).setter(GetApplicationResponse.setter(Builder::quickSightConfiguration)).constructor(QuickSightConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quickSightConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD, APPLICATION_ID_FIELD, APPLICATION_ARN_FIELD, IDENTITY_TYPE_FIELD, IAM_IDENTITY_PROVIDER_ARN_FIELD, IDENTITY_CENTER_APPLICATION_ARN_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, ERROR_FIELD, ATTACHMENTS_CONFIGURATION_FIELD, Q_APPS_CONFIGURATION_FIELD, PERSONALIZATION_CONFIGURATION_FIELD, AUTO_SUBSCRIPTION_CONFIGURATION_FIELD, CLIENT_IDS_FOR_OIDC_FIELD, QUICK_SIGHT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetApplicationResponse.memberNameToFieldInitializer();
    private final String displayName;
    private final String applicationId;
    private final String applicationArn;
    private final String identityType;
    private final String iamIdentityProviderArn;
    private final String identityCenterApplicationArn;
    private final String roleArn;
    private final String status;
    private final String description;
    private final EncryptionConfiguration encryptionConfiguration;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final ErrorDetail error;
    private final AppliedAttachmentsConfiguration attachmentsConfiguration;
    private final QAppsConfiguration qAppsConfiguration;
    private final PersonalizationConfiguration personalizationConfiguration;
    private final AutoSubscriptionConfiguration autoSubscriptionConfiguration;
    private final List<String> clientIdsForOIDC;
    private final QuickSightConfiguration quickSightConfiguration;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.applicationId = builder.applicationId;
        this.applicationArn = builder.applicationArn;
        this.identityType = builder.identityType;
        this.iamIdentityProviderArn = builder.iamIdentityProviderArn;
        this.identityCenterApplicationArn = builder.identityCenterApplicationArn;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.description = builder.description;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.error = builder.error;
        this.attachmentsConfiguration = builder.attachmentsConfiguration;
        this.qAppsConfiguration = builder.qAppsConfiguration;
        this.personalizationConfiguration = builder.personalizationConfiguration;
        this.autoSubscriptionConfiguration = builder.autoSubscriptionConfiguration;
        this.clientIdsForOIDC = builder.clientIdsForOIDC;
        this.quickSightConfiguration = builder.quickSightConfiguration;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final IdentityType identityType() {
        return IdentityType.fromValue(this.identityType);
    }

    public final String identityTypeAsString() {
        return this.identityType;
    }

    public final String iamIdentityProviderArn() {
        return this.iamIdentityProviderArn;
    }

    public final String identityCenterApplicationArn() {
        return this.identityCenterApplicationArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final ErrorDetail error() {
        return this.error;
    }

    public final AppliedAttachmentsConfiguration attachmentsConfiguration() {
        return this.attachmentsConfiguration;
    }

    public final QAppsConfiguration qAppsConfiguration() {
        return this.qAppsConfiguration;
    }

    public final PersonalizationConfiguration personalizationConfiguration() {
        return this.personalizationConfiguration;
    }

    public final AutoSubscriptionConfiguration autoSubscriptionConfiguration() {
        return this.autoSubscriptionConfiguration;
    }

    public final boolean hasClientIdsForOIDC() {
        return this.clientIdsForOIDC != null && !(this.clientIdsForOIDC instanceof SdkAutoConstructList);
    }

    public final List<String> clientIdsForOIDC() {
        return this.clientIdsForOIDC;
    }

    public final QuickSightConfiguration quickSightConfiguration() {
        return this.quickSightConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.qAppsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalizationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoSubscriptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientIdsForOIDC() ? this.clientIdsForOIDC() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.quickSightConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse)((Object)obj);
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(this.iamIdentityProviderArn(), other.iamIdentityProviderArn()) && Objects.equals(this.identityCenterApplicationArn(), other.identityCenterApplicationArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.attachmentsConfiguration(), other.attachmentsConfiguration()) && Objects.equals(this.qAppsConfiguration(), other.qAppsConfiguration()) && Objects.equals(this.personalizationConfiguration(), other.personalizationConfiguration()) && Objects.equals(this.autoSubscriptionConfiguration(), other.autoSubscriptionConfiguration()) && this.hasClientIdsForOIDC() == other.hasClientIdsForOIDC() && Objects.equals(this.clientIdsForOIDC(), other.clientIdsForOIDC()) && Objects.equals(this.quickSightConfiguration(), other.quickSightConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetApplicationResponse").add("DisplayName", (Object)this.displayName()).add("ApplicationId", (Object)this.applicationId()).add("ApplicationArn", (Object)this.applicationArn()).add("IdentityType", (Object)this.identityTypeAsString()).add("IamIdentityProviderArn", (Object)this.iamIdentityProviderArn()).add("IdentityCenterApplicationArn", (Object)this.identityCenterApplicationArn()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Error", (Object)this.error()).add("AttachmentsConfiguration", (Object)this.attachmentsConfiguration()).add("QAppsConfiguration", (Object)this.qAppsConfiguration()).add("PersonalizationConfiguration", (Object)this.personalizationConfiguration()).add("AutoSubscriptionConfiguration", (Object)this.autoSubscriptionConfiguration()).add("ClientIdsForOIDC", this.hasClientIdsForOIDC() ? this.clientIdsForOIDC() : null).add("QuickSightConfiguration", (Object)this.quickSightConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "applicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "identityType": {
                return Optional.ofNullable(clazz.cast(this.identityTypeAsString()));
            }
            case "iamIdentityProviderArn": {
                return Optional.ofNullable(clazz.cast(this.iamIdentityProviderArn()));
            }
            case "identityCenterApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.identityCenterApplicationArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "attachmentsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.attachmentsConfiguration()));
            }
            case "qAppsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.qAppsConfiguration()));
            }
            case "personalizationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.personalizationConfiguration()));
            }
            case "autoSubscriptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoSubscriptionConfiguration()));
            }
            case "clientIdsForOIDC": {
                return Optional.ofNullable(clazz.cast(this.clientIdsForOIDC()));
            }
            case "quickSightConfiguration": {
                return Optional.ofNullable(clazz.cast(this.quickSightConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        map.put("identityType", IDENTITY_TYPE_FIELD);
        map.put("iamIdentityProviderArn", IAM_IDENTITY_PROVIDER_ARN_FIELD);
        map.put("identityCenterApplicationArn", IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("attachmentsConfiguration", ATTACHMENTS_CONFIGURATION_FIELD);
        map.put("qAppsConfiguration", Q_APPS_CONFIGURATION_FIELD);
        map.put("personalizationConfiguration", PERSONALIZATION_CONFIGURATION_FIELD);
        map.put("autoSubscriptionConfiguration", AUTO_SUBSCRIPTION_CONFIGURATION_FIELD);
        map.put("clientIdsForOIDC", CLIENT_IDS_FOR_OIDC_FIELD);
        map.put("quickSightConfiguration", QUICK_SIGHT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String displayName;
        private String applicationId;
        private String applicationArn;
        private String identityType;
        private String iamIdentityProviderArn;
        private String identityCenterApplicationArn;
        private String roleArn;
        private String status;
        private String description;
        private EncryptionConfiguration encryptionConfiguration;
        private Instant createdAt;
        private Instant updatedAt;
        private ErrorDetail error;
        private AppliedAttachmentsConfiguration attachmentsConfiguration;
        private QAppsConfiguration qAppsConfiguration;
        private PersonalizationConfiguration personalizationConfiguration;
        private AutoSubscriptionConfiguration autoSubscriptionConfiguration;
        private List<String> clientIdsForOIDC = DefaultSdkAutoConstructList.getInstance();
        private QuickSightConfiguration quickSightConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            this.displayName(model.displayName);
            this.applicationId(model.applicationId);
            this.applicationArn(model.applicationArn);
            this.identityType(model.identityType);
            this.iamIdentityProviderArn(model.iamIdentityProviderArn);
            this.identityCenterApplicationArn(model.identityCenterApplicationArn);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.description(model.description);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.error(model.error);
            this.attachmentsConfiguration(model.attachmentsConfiguration);
            this.qAppsConfiguration(model.qAppsConfiguration);
            this.personalizationConfiguration(model.personalizationConfiguration);
            this.autoSubscriptionConfiguration(model.autoSubscriptionConfiguration);
            this.clientIdsForOIDC(model.clientIdsForOIDC);
            this.quickSightConfiguration(model.quickSightConfiguration);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final String getIamIdentityProviderArn() {
            return this.iamIdentityProviderArn;
        }

        public final void setIamIdentityProviderArn(String iamIdentityProviderArn) {
            this.iamIdentityProviderArn = iamIdentityProviderArn;
        }

        @Override
        public final Builder iamIdentityProviderArn(String iamIdentityProviderArn) {
            this.iamIdentityProviderArn = iamIdentityProviderArn;
            return this;
        }

        public final String getIdentityCenterApplicationArn() {
            return this.identityCenterApplicationArn;
        }

        public final void setIdentityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
        }

        @Override
        public final Builder identityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final AppliedAttachmentsConfiguration.Builder getAttachmentsConfiguration() {
            return this.attachmentsConfiguration != null ? this.attachmentsConfiguration.toBuilder() : null;
        }

        public final void setAttachmentsConfiguration(AppliedAttachmentsConfiguration.BuilderImpl attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration != null ? attachmentsConfiguration.build() : null;
        }

        @Override
        public final Builder attachmentsConfiguration(AppliedAttachmentsConfiguration attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration;
            return this;
        }

        public final QAppsConfiguration.Builder getQAppsConfiguration() {
            return this.qAppsConfiguration != null ? this.qAppsConfiguration.toBuilder() : null;
        }

        public final void setQAppsConfiguration(QAppsConfiguration.BuilderImpl qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration != null ? qAppsConfiguration.build() : null;
        }

        @Override
        public final Builder qAppsConfiguration(QAppsConfiguration qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration;
            return this;
        }

        public final PersonalizationConfiguration.Builder getPersonalizationConfiguration() {
            return this.personalizationConfiguration != null ? this.personalizationConfiguration.toBuilder() : null;
        }

        public final void setPersonalizationConfiguration(PersonalizationConfiguration.BuilderImpl personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration != null ? personalizationConfiguration.build() : null;
        }

        @Override
        public final Builder personalizationConfiguration(PersonalizationConfiguration personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration;
            return this;
        }

        public final AutoSubscriptionConfiguration.Builder getAutoSubscriptionConfiguration() {
            return this.autoSubscriptionConfiguration != null ? this.autoSubscriptionConfiguration.toBuilder() : null;
        }

        public final void setAutoSubscriptionConfiguration(AutoSubscriptionConfiguration.BuilderImpl autoSubscriptionConfiguration) {
            this.autoSubscriptionConfiguration = autoSubscriptionConfiguration != null ? autoSubscriptionConfiguration.build() : null;
        }

        @Override
        public final Builder autoSubscriptionConfiguration(AutoSubscriptionConfiguration autoSubscriptionConfiguration) {
            this.autoSubscriptionConfiguration = autoSubscriptionConfiguration;
            return this;
        }

        public final Collection<String> getClientIdsForOIDC() {
            if (this.clientIdsForOIDC instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientIdsForOIDC;
        }

        public final void setClientIdsForOIDC(Collection<String> clientIdsForOIDC) {
            this.clientIdsForOIDC = ClientIdsForOIDCCopier.copy(clientIdsForOIDC);
        }

        @Override
        public final Builder clientIdsForOIDC(Collection<String> clientIdsForOIDC) {
            this.clientIdsForOIDC = ClientIdsForOIDCCopier.copy(clientIdsForOIDC);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIdsForOIDC(String ... clientIdsForOIDC) {
            this.clientIdsForOIDC(Arrays.asList(clientIdsForOIDC));
            return this;
        }

        public final QuickSightConfiguration.Builder getQuickSightConfiguration() {
            return this.quickSightConfiguration != null ? this.quickSightConfiguration.toBuilder() : null;
        }

        public final void setQuickSightConfiguration(QuickSightConfiguration.BuilderImpl quickSightConfiguration) {
            this.quickSightConfiguration = quickSightConfiguration != null ? quickSightConfiguration.build() : null;
        }

        @Override
        public final Builder quickSightConfiguration(QuickSightConfiguration quickSightConfiguration) {
            this.quickSightConfiguration = quickSightConfiguration;
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationResponse> {
        public Builder displayName(String var1);

        public Builder applicationId(String var1);

        public Builder applicationArn(String var1);

        public Builder identityType(String var1);

        public Builder identityType(IdentityType var1);

        public Builder iamIdentityProviderArn(String var1);

        public Builder identityCenterApplicationArn(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(ApplicationStatus var1);

        public Builder description(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder error(ErrorDetail var1);

        default public Builder error(Consumer<ErrorDetail.Builder> error) {
            return this.error((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(error)).build());
        }

        public Builder attachmentsConfiguration(AppliedAttachmentsConfiguration var1);

        default public Builder attachmentsConfiguration(Consumer<AppliedAttachmentsConfiguration.Builder> attachmentsConfiguration) {
            return this.attachmentsConfiguration((AppliedAttachmentsConfiguration)((AppliedAttachmentsConfiguration.Builder)AppliedAttachmentsConfiguration.builder().applyMutation(attachmentsConfiguration)).build());
        }

        public Builder qAppsConfiguration(QAppsConfiguration var1);

        default public Builder qAppsConfiguration(Consumer<QAppsConfiguration.Builder> qAppsConfiguration) {
            return this.qAppsConfiguration((QAppsConfiguration)((QAppsConfiguration.Builder)QAppsConfiguration.builder().applyMutation(qAppsConfiguration)).build());
        }

        public Builder personalizationConfiguration(PersonalizationConfiguration var1);

        default public Builder personalizationConfiguration(Consumer<PersonalizationConfiguration.Builder> personalizationConfiguration) {
            return this.personalizationConfiguration((PersonalizationConfiguration)((PersonalizationConfiguration.Builder)PersonalizationConfiguration.builder().applyMutation(personalizationConfiguration)).build());
        }

        public Builder autoSubscriptionConfiguration(AutoSubscriptionConfiguration var1);

        default public Builder autoSubscriptionConfiguration(Consumer<AutoSubscriptionConfiguration.Builder> autoSubscriptionConfiguration) {
            return this.autoSubscriptionConfiguration((AutoSubscriptionConfiguration)((AutoSubscriptionConfiguration.Builder)AutoSubscriptionConfiguration.builder().applyMutation(autoSubscriptionConfiguration)).build());
        }

        public Builder clientIdsForOIDC(Collection<String> var1);

        public Builder clientIdsForOIDC(String ... var1);

        public Builder quickSightConfiguration(QuickSightConfiguration var1);

        default public Builder quickSightConfiguration(Consumer<QuickSightConfiguration.Builder> quickSightConfiguration) {
            return this.quickSightConfiguration((QuickSightConfiguration)((QuickSightConfiguration.Builder)QuickSightConfiguration.builder().applyMutation(quickSightConfiguration)).build());
        }
    }
}

