/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PluginTypeCategory {
    CUSTOMER_RELATIONSHIP_MANAGEMENT_CRM("Customer relationship management (CRM)"),
    PROJECT_MANAGEMENT("Project management"),
    COMMUNICATION("Communication"),
    PRODUCTIVITY("Productivity"),
    TICKETING_AND_INCIDENT_MANAGEMENT("Ticketing and incident management"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PluginTypeCategory> VALUE_MAP;
    private final String value;

    private PluginTypeCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PluginTypeCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PluginTypeCategory> knownValues() {
        EnumSet<PluginTypeCategory> knownValues = EnumSet.allOf(PluginTypeCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PluginTypeCategory.class, PluginTypeCategory::toString);
    }
}

