/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.ActionReviewPayloadCopier;
import software.amazon.awssdk.services.qbusiness.model.ActionReviewPayloadField;
import software.amazon.awssdk.services.qbusiness.model.ChatOutputStream;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseHandler;
import software.amazon.awssdk.services.qbusiness.model.PluginType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionReviewEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionReviewEvent>,
ChatOutputStream {
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationId").getter(ActionReviewEvent.getter(ActionReviewEvent::conversationId)).setter(ActionReviewEvent.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()}).build();
    private static final SdkField<String> USER_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userMessageId").getter(ActionReviewEvent.getter(ActionReviewEvent::userMessageId)).setter(ActionReviewEvent.setter(Builder::userMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessageId").build()}).build();
    private static final SdkField<String> SYSTEM_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemMessageId").getter(ActionReviewEvent.getter(ActionReviewEvent::systemMessageId)).setter(ActionReviewEvent.setter(Builder::systemMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageId").build()}).build();
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginId").getter(ActionReviewEvent.getter(ActionReviewEvent::pluginId)).setter(ActionReviewEvent.setter(Builder::pluginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()}).build();
    private static final SdkField<String> PLUGIN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginType").getter(ActionReviewEvent.getter(ActionReviewEvent::pluginTypeAsString)).setter(ActionReviewEvent.setter(Builder::pluginType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginType").build()}).build();
    private static final SdkField<Map<String, ActionReviewPayloadField>> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("payload").getter(ActionReviewEvent.getter(ActionReviewEvent::payload)).setter(ActionReviewEvent.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionReviewPayloadField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PAYLOAD_FIELD_NAME_SEPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("payloadFieldNameSeparator").getter(ActionReviewEvent.getter(ActionReviewEvent::payloadFieldNameSeparator)).setter(ActionReviewEvent.setter(Builder::payloadFieldNameSeparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadFieldNameSeparator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_ID_FIELD, USER_MESSAGE_ID_FIELD, SYSTEM_MESSAGE_ID_FIELD, PLUGIN_ID_FIELD, PLUGIN_TYPE_FIELD, PAYLOAD_FIELD, PAYLOAD_FIELD_NAME_SEPARATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActionReviewEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String conversationId;
    private final String userMessageId;
    private final String systemMessageId;
    private final String pluginId;
    private final String pluginType;
    private final Map<String, ActionReviewPayloadField> payload;
    private final String payloadFieldNameSeparator;

    protected ActionReviewEvent(BuilderImpl builder) {
        this.conversationId = builder.conversationId;
        this.userMessageId = builder.userMessageId;
        this.systemMessageId = builder.systemMessageId;
        this.pluginId = builder.pluginId;
        this.pluginType = builder.pluginType;
        this.payload = builder.payload;
        this.payloadFieldNameSeparator = builder.payloadFieldNameSeparator;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final String userMessageId() {
        return this.userMessageId;
    }

    public final String systemMessageId() {
        return this.systemMessageId;
    }

    public final String pluginId() {
        return this.pluginId;
    }

    public final PluginType pluginType() {
        return PluginType.fromValue(this.pluginType);
    }

    public final String pluginTypeAsString() {
        return this.pluginType;
    }

    public final boolean hasPayload() {
        return this.payload != null && !(this.payload instanceof SdkAutoConstructMap);
    }

    public final Map<String, ActionReviewPayloadField> payload() {
        return this.payload;
    }

    public final String payloadFieldNameSeparator() {
        return this.payloadFieldNameSeparator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPayload() ? this.payload() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadFieldNameSeparator());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionReviewEvent)) {
            return false;
        }
        ActionReviewEvent other = (ActionReviewEvent)obj;
        return Objects.equals(this.conversationId(), other.conversationId()) && Objects.equals(this.userMessageId(), other.userMessageId()) && Objects.equals(this.systemMessageId(), other.systemMessageId()) && Objects.equals(this.pluginId(), other.pluginId()) && Objects.equals(this.pluginTypeAsString(), other.pluginTypeAsString()) && this.hasPayload() == other.hasPayload() && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.payloadFieldNameSeparator(), other.payloadFieldNameSeparator());
    }

    public final String toString() {
        return ToString.builder((String)"ActionReviewEvent").add("ConversationId", (Object)this.conversationId()).add("UserMessageId", (Object)this.userMessageId()).add("SystemMessageId", (Object)this.systemMessageId()).add("PluginId", (Object)this.pluginId()).add("PluginType", (Object)this.pluginTypeAsString()).add("Payload", this.hasPayload() ? this.payload() : null).add("PayloadFieldNameSeparator", (Object)this.payloadFieldNameSeparator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "userMessageId": {
                return Optional.ofNullable(clazz.cast(this.userMessageId()));
            }
            case "systemMessageId": {
                return Optional.ofNullable(clazz.cast(this.systemMessageId()));
            }
            case "pluginId": {
                return Optional.ofNullable(clazz.cast(this.pluginId()));
            }
            case "pluginType": {
                return Optional.ofNullable(clazz.cast(this.pluginTypeAsString()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "payloadFieldNameSeparator": {
                return Optional.ofNullable(clazz.cast(this.payloadFieldNameSeparator()));
            }
        }
        return Optional.empty();
    }

    public final ActionReviewEvent copy(Consumer<? super Builder> modifier) {
        return (ActionReviewEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("userMessageId", USER_MESSAGE_ID_FIELD);
        map.put("systemMessageId", SYSTEM_MESSAGE_ID_FIELD);
        map.put("pluginId", PLUGIN_ID_FIELD);
        map.put("pluginType", PLUGIN_TYPE_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("payloadFieldNameSeparator", PAYLOAD_FIELD_NAME_SEPARATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionReviewEvent, T> g) {
        return obj -> g.apply((ActionReviewEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(ChatResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private String conversationId;
        private String userMessageId;
        private String systemMessageId;
        private String pluginId;
        private String pluginType;
        private Map<String, ActionReviewPayloadField> payload = DefaultSdkAutoConstructMap.getInstance();
        private String payloadFieldNameSeparator;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ActionReviewEvent model) {
            this.conversationId(model.conversationId);
            this.userMessageId(model.userMessageId);
            this.systemMessageId(model.systemMessageId);
            this.pluginId(model.pluginId);
            this.pluginType(model.pluginType);
            this.payload(model.payload);
            this.payloadFieldNameSeparator(model.payloadFieldNameSeparator);
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getUserMessageId() {
            return this.userMessageId;
        }

        public final void setUserMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
        }

        @Override
        public final Builder userMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
            return this;
        }

        public final String getSystemMessageId() {
            return this.systemMessageId;
        }

        public final void setSystemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
        }

        @Override
        public final Builder systemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
            return this;
        }

        public final String getPluginId() {
            return this.pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getPluginType() {
            return this.pluginType;
        }

        public final void setPluginType(String pluginType) {
            this.pluginType = pluginType;
        }

        @Override
        public final Builder pluginType(String pluginType) {
            this.pluginType = pluginType;
            return this;
        }

        @Override
        public final Builder pluginType(PluginType pluginType) {
            this.pluginType(pluginType == null ? null : pluginType.toString());
            return this;
        }

        public final Map<String, ActionReviewPayloadField.Builder> getPayload() {
            Map<String, ActionReviewPayloadField.Builder> result = ActionReviewPayloadCopier.copyToBuilder(this.payload);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPayload(Map<String, ActionReviewPayloadField.BuilderImpl> payload) {
            this.payload = ActionReviewPayloadCopier.copyFromBuilder(payload);
        }

        @Override
        public final Builder payload(Map<String, ActionReviewPayloadField> payload) {
            this.payload = ActionReviewPayloadCopier.copy(payload);
            return this;
        }

        public final String getPayloadFieldNameSeparator() {
            return this.payloadFieldNameSeparator;
        }

        public final void setPayloadFieldNameSeparator(String payloadFieldNameSeparator) {
            this.payloadFieldNameSeparator = payloadFieldNameSeparator;
        }

        @Override
        public final Builder payloadFieldNameSeparator(String payloadFieldNameSeparator) {
            this.payloadFieldNameSeparator = payloadFieldNameSeparator;
            return this;
        }

        public ActionReviewEvent build() {
            return new ActionReviewEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionReviewEvent> {
        public Builder conversationId(String var1);

        public Builder userMessageId(String var1);

        public Builder systemMessageId(String var1);

        public Builder pluginId(String var1);

        public Builder pluginType(String var1);

        public Builder pluginType(PluginType var1);

        public Builder payload(Map<String, ActionReviewPayloadField> var1);

        public Builder payloadFieldNameSeparator(String var1);
    }
}

