/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.VideoExtractionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoSourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoSourceDetails> {
    private static final SdkField<String> MEDIA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mediaId").getter(VideoSourceDetails.getter(VideoSourceDetails::mediaId)).setter(VideoSourceDetails.setter(Builder::mediaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaId").build()}).build();
    private static final SdkField<String> MEDIA_MIME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mediaMimeType").getter(VideoSourceDetails.getter(VideoSourceDetails::mediaMimeType)).setter(VideoSourceDetails.setter(Builder::mediaMimeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaMimeType").build()}).build();
    private static final SdkField<Long> START_TIME_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startTimeMilliseconds").getter(VideoSourceDetails.getter(VideoSourceDetails::startTimeMilliseconds)).setter(VideoSourceDetails.setter(Builder::startTimeMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeMilliseconds").build()}).build();
    private static final SdkField<Long> END_TIME_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("endTimeMilliseconds").getter(VideoSourceDetails.getter(VideoSourceDetails::endTimeMilliseconds)).setter(VideoSourceDetails.setter(Builder::endTimeMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeMilliseconds").build()}).build();
    private static final SdkField<String> VIDEO_EXTRACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("videoExtractionType").getter(VideoSourceDetails.getter(VideoSourceDetails::videoExtractionTypeAsString)).setter(VideoSourceDetails.setter(Builder::videoExtractionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoExtractionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_ID_FIELD, MEDIA_MIME_TYPE_FIELD, START_TIME_MILLISECONDS_FIELD, END_TIME_MILLISECONDS_FIELD, VIDEO_EXTRACTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoSourceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mediaId;
    private final String mediaMimeType;
    private final Long startTimeMilliseconds;
    private final Long endTimeMilliseconds;
    private final String videoExtractionType;

    private VideoSourceDetails(BuilderImpl builder) {
        this.mediaId = builder.mediaId;
        this.mediaMimeType = builder.mediaMimeType;
        this.startTimeMilliseconds = builder.startTimeMilliseconds;
        this.endTimeMilliseconds = builder.endTimeMilliseconds;
        this.videoExtractionType = builder.videoExtractionType;
    }

    public final String mediaId() {
        return this.mediaId;
    }

    public final String mediaMimeType() {
        return this.mediaMimeType;
    }

    public final Long startTimeMilliseconds() {
        return this.startTimeMilliseconds;
    }

    public final Long endTimeMilliseconds() {
        return this.endTimeMilliseconds;
    }

    public final VideoExtractionType videoExtractionType() {
        return VideoExtractionType.fromValue(this.videoExtractionType);
    }

    public final String videoExtractionTypeAsString() {
        return this.videoExtractionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaMimeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimeMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoExtractionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSourceDetails)) {
            return false;
        }
        VideoSourceDetails other = (VideoSourceDetails)obj;
        return Objects.equals(this.mediaId(), other.mediaId()) && Objects.equals(this.mediaMimeType(), other.mediaMimeType()) && Objects.equals(this.startTimeMilliseconds(), other.startTimeMilliseconds()) && Objects.equals(this.endTimeMilliseconds(), other.endTimeMilliseconds()) && Objects.equals(this.videoExtractionTypeAsString(), other.videoExtractionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VideoSourceDetails").add("MediaId", (Object)this.mediaId()).add("MediaMimeType", (Object)this.mediaMimeType()).add("StartTimeMilliseconds", (Object)this.startTimeMilliseconds()).add("EndTimeMilliseconds", (Object)this.endTimeMilliseconds()).add("VideoExtractionType", (Object)this.videoExtractionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mediaId": {
                return Optional.ofNullable(clazz.cast(this.mediaId()));
            }
            case "mediaMimeType": {
                return Optional.ofNullable(clazz.cast(this.mediaMimeType()));
            }
            case "startTimeMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.startTimeMilliseconds()));
            }
            case "endTimeMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.endTimeMilliseconds()));
            }
            case "videoExtractionType": {
                return Optional.ofNullable(clazz.cast(this.videoExtractionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mediaId", MEDIA_ID_FIELD);
        map.put("mediaMimeType", MEDIA_MIME_TYPE_FIELD);
        map.put("startTimeMilliseconds", START_TIME_MILLISECONDS_FIELD);
        map.put("endTimeMilliseconds", END_TIME_MILLISECONDS_FIELD);
        map.put("videoExtractionType", VIDEO_EXTRACTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoSourceDetails, T> g) {
        return obj -> g.apply((VideoSourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mediaId;
        private String mediaMimeType;
        private Long startTimeMilliseconds;
        private Long endTimeMilliseconds;
        private String videoExtractionType;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSourceDetails model) {
            this.mediaId(model.mediaId);
            this.mediaMimeType(model.mediaMimeType);
            this.startTimeMilliseconds(model.startTimeMilliseconds);
            this.endTimeMilliseconds(model.endTimeMilliseconds);
            this.videoExtractionType(model.videoExtractionType);
        }

        public final String getMediaId() {
            return this.mediaId;
        }

        public final void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @Override
        public final Builder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public final String getMediaMimeType() {
            return this.mediaMimeType;
        }

        public final void setMediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
        }

        @Override
        public final Builder mediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
            return this;
        }

        public final Long getStartTimeMilliseconds() {
            return this.startTimeMilliseconds;
        }

        public final void setStartTimeMilliseconds(Long startTimeMilliseconds) {
            this.startTimeMilliseconds = startTimeMilliseconds;
        }

        @Override
        public final Builder startTimeMilliseconds(Long startTimeMilliseconds) {
            this.startTimeMilliseconds = startTimeMilliseconds;
            return this;
        }

        public final Long getEndTimeMilliseconds() {
            return this.endTimeMilliseconds;
        }

        public final void setEndTimeMilliseconds(Long endTimeMilliseconds) {
            this.endTimeMilliseconds = endTimeMilliseconds;
        }

        @Override
        public final Builder endTimeMilliseconds(Long endTimeMilliseconds) {
            this.endTimeMilliseconds = endTimeMilliseconds;
            return this;
        }

        public final String getVideoExtractionType() {
            return this.videoExtractionType;
        }

        public final void setVideoExtractionType(String videoExtractionType) {
            this.videoExtractionType = videoExtractionType;
        }

        @Override
        public final Builder videoExtractionType(String videoExtractionType) {
            this.videoExtractionType = videoExtractionType;
            return this;
        }

        @Override
        public final Builder videoExtractionType(VideoExtractionType videoExtractionType) {
            this.videoExtractionType(videoExtractionType == null ? null : videoExtractionType.toString());
            return this;
        }

        public VideoSourceDetails build() {
            return new VideoSourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoSourceDetails> {
        public Builder mediaId(String var1);

        public Builder mediaMimeType(String var1);

        public Builder startTimeMilliseconds(Long var1);

        public Builder endTimeMilliseconds(Long var1);

        public Builder videoExtractionType(String var1);

        public Builder videoExtractionType(VideoExtractionType var1);
    }
}

