/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.SubscriptionDetails;
import software.amazon.awssdk.services.qbusiness.model.SubscriptionPrincipal;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subscription> {
    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionId").getter(Subscription.getter(Subscription::subscriptionId)).setter(Subscription.setter(Builder::subscriptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionId").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionArn").getter(Subscription.getter(Subscription::subscriptionArn)).setter(Subscription.setter(Builder::subscriptionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionArn").build()}).build();
    private static final SdkField<SubscriptionPrincipal> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("principal").getter(Subscription.getter(Subscription::principal)).setter(Subscription.setter(Builder::principal)).constructor(SubscriptionPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<SubscriptionDetails> CURRENT_SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentSubscription").getter(Subscription.getter(Subscription::currentSubscription)).setter(Subscription.setter(Builder::currentSubscription)).constructor(SubscriptionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentSubscription").build()}).build();
    private static final SdkField<SubscriptionDetails> NEXT_SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nextSubscription").getter(Subscription.getter(Subscription::nextSubscription)).setter(Subscription.setter(Builder::nextSubscription)).constructor(SubscriptionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextSubscription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ID_FIELD, SUBSCRIPTION_ARN_FIELD, PRINCIPAL_FIELD, CURRENT_SUBSCRIPTION_FIELD, NEXT_SUBSCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Subscription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subscriptionId;
    private final String subscriptionArn;
    private final SubscriptionPrincipal principal;
    private final SubscriptionDetails currentSubscription;
    private final SubscriptionDetails nextSubscription;

    private Subscription(BuilderImpl builder) {
        this.subscriptionId = builder.subscriptionId;
        this.subscriptionArn = builder.subscriptionArn;
        this.principal = builder.principal;
        this.currentSubscription = builder.currentSubscription;
        this.nextSubscription = builder.nextSubscription;
    }

    public final String subscriptionId() {
        return this.subscriptionId;
    }

    public final String subscriptionArn() {
        return this.subscriptionArn;
    }

    public final SubscriptionPrincipal principal() {
        return this.principal;
    }

    public final SubscriptionDetails currentSubscription() {
        return this.currentSubscription;
    }

    public final SubscriptionDetails nextSubscription() {
        return this.nextSubscription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSubscription());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextSubscription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return Objects.equals(this.subscriptionId(), other.subscriptionId()) && Objects.equals(this.subscriptionArn(), other.subscriptionArn()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.currentSubscription(), other.currentSubscription()) && Objects.equals(this.nextSubscription(), other.nextSubscription());
    }

    public final String toString() {
        return ToString.builder((String)"Subscription").add("SubscriptionId", (Object)this.subscriptionId()).add("SubscriptionArn", (Object)this.subscriptionArn()).add("Principal", (Object)this.principal()).add("CurrentSubscription", (Object)this.currentSubscription()).add("NextSubscription", (Object)this.nextSubscription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "subscriptionId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionId()));
            }
            case "subscriptionArn": {
                return Optional.ofNullable(clazz.cast(this.subscriptionArn()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "currentSubscription": {
                return Optional.ofNullable(clazz.cast(this.currentSubscription()));
            }
            case "nextSubscription": {
                return Optional.ofNullable(clazz.cast(this.nextSubscription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subscriptionId", SUBSCRIPTION_ID_FIELD);
        map.put("subscriptionArn", SUBSCRIPTION_ARN_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("currentSubscription", CURRENT_SUBSCRIPTION_FIELD);
        map.put("nextSubscription", NEXT_SUBSCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subscriptionId;
        private String subscriptionArn;
        private SubscriptionPrincipal principal;
        private SubscriptionDetails currentSubscription;
        private SubscriptionDetails nextSubscription;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.subscriptionId(model.subscriptionId);
            this.subscriptionArn(model.subscriptionArn);
            this.principal(model.principal);
            this.currentSubscription(model.currentSubscription);
            this.nextSubscription(model.nextSubscription);
        }

        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final String getSubscriptionArn() {
            return this.subscriptionArn;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final SubscriptionPrincipal.Builder getPrincipal() {
            return this.principal != null ? this.principal.toBuilder() : null;
        }

        public final void setPrincipal(SubscriptionPrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(SubscriptionPrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final SubscriptionDetails.Builder getCurrentSubscription() {
            return this.currentSubscription != null ? this.currentSubscription.toBuilder() : null;
        }

        public final void setCurrentSubscription(SubscriptionDetails.BuilderImpl currentSubscription) {
            this.currentSubscription = currentSubscription != null ? currentSubscription.build() : null;
        }

        @Override
        public final Builder currentSubscription(SubscriptionDetails currentSubscription) {
            this.currentSubscription = currentSubscription;
            return this;
        }

        public final SubscriptionDetails.Builder getNextSubscription() {
            return this.nextSubscription != null ? this.nextSubscription.toBuilder() : null;
        }

        public final void setNextSubscription(SubscriptionDetails.BuilderImpl nextSubscription) {
            this.nextSubscription = nextSubscription != null ? nextSubscription.build() : null;
        }

        @Override
        public final Builder nextSubscription(SubscriptionDetails nextSubscription) {
            this.nextSubscription = nextSubscription;
            return this;
        }

        public Subscription build() {
            return new Subscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subscription> {
        public Builder subscriptionId(String var1);

        public Builder subscriptionArn(String var1);

        public Builder principal(SubscriptionPrincipal var1);

        default public Builder principal(Consumer<SubscriptionPrincipal.Builder> principal) {
            return this.principal((SubscriptionPrincipal)((SubscriptionPrincipal.Builder)SubscriptionPrincipal.builder().applyMutation(principal)).build());
        }

        public Builder currentSubscription(SubscriptionDetails var1);

        default public Builder currentSubscription(Consumer<SubscriptionDetails.Builder> currentSubscription) {
            return this.currentSubscription((SubscriptionDetails)((SubscriptionDetails.Builder)SubscriptionDetails.builder().applyMutation(currentSubscription)).build());
        }

        public Builder nextSubscription(SubscriptionDetails var1);

        default public Builder nextSubscription(Consumer<SubscriptionDetails.Builder> nextSubscription) {
            return this.nextSubscription((SubscriptionDetails)((SubscriptionDetails.Builder)SubscriptionDetails.builder().applyMutation(nextSubscription)).build());
        }
    }
}

