/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.CategoryIdListCopier;
import software.amazon.awssdk.services.qapps.model.QAppsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLibraryItemRequest
extends QAppsRequest
implements ToCopyableBuilder<Builder, CreateLibraryItemRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(CreateLibraryItemRequest.getter(CreateLibraryItemRequest::instanceId)).setter(CreateLibraryItemRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(CreateLibraryItemRequest.getter(CreateLibraryItemRequest::appId)).setter(CreateLibraryItemRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<Integer> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("appVersion").getter(CreateLibraryItemRequest.getter(CreateLibraryItemRequest::appVersion)).setter(CreateLibraryItemRequest.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("categories").getter(CreateLibraryItemRequest.getter(CreateLibraryItemRequest::categories)).setter(CreateLibraryItemRequest.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, APP_ID_FIELD, APP_VERSION_FIELD, CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLibraryItemRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String appId;
    private final Integer appVersion;
    private final List<String> categories;

    private CreateLibraryItemRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.appId = builder.appId;
        this.appVersion = builder.appVersion;
        this.categories = builder.categories;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String appId() {
        return this.appId;
    }

    public final Integer appVersion() {
        return this.appVersion;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<String> categories() {
        return this.categories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLibraryItemRequest)) {
            return false;
        }
        CreateLibraryItemRequest other = (CreateLibraryItemRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.appVersion(), other.appVersion()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLibraryItemRequest").add("InstanceId", (Object)this.instanceId()).add("AppId", (Object)this.appId()).add("AppVersion", (Object)this.appVersion()).add("Categories", this.hasCategories() ? this.categories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instance-id", INSTANCE_ID_FIELD);
        map.put("appId", APP_ID_FIELD);
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("categories", CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLibraryItemRequest, T> g) {
        return obj -> g.apply((CreateLibraryItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String appId;
        private Integer appVersion;
        private List<String> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLibraryItemRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.appId(model.appId);
            this.appVersion(model.appVersion);
            this.categories(model.categories);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final Integer getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(Integer appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(Integer appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final Collection<String> getCategories() {
            if (this.categories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = CategoryIdListCopier.copy(categories);
        }

        @Override
        public final Builder categories(Collection<String> categories) {
            this.categories = CategoryIdListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(String ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLibraryItemRequest build() {
            return new CreateLibraryItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QAppsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLibraryItemRequest> {
        public Builder instanceId(String var1);

        public Builder appId(String var1);

        public Builder appVersion(Integer var1);

        public Builder categories(Collection<String> var1);

        public Builder categories(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

