/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServicePipelineState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServicePipelineState> {
    private static final SdkField<String> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spec").getter(ServicePipelineState.getter(ServicePipelineState::spec)).setter(ServicePipelineState.setter(Builder::spec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateMajorVersion").getter(ServicePipelineState.getter(ServicePipelineState::templateMajorVersion)).setter(ServicePipelineState.setter(Builder::templateMajorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build()}).build();
    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateMinorVersion").getter(ServicePipelineState.getter(ServicePipelineState::templateMinorVersion)).setter(ServicePipelineState.setter(Builder::templateMinorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(ServicePipelineState.getter(ServicePipelineState::templateName)).setter(ServicePipelineState.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEC_FIELD, TEMPLATE_MAJOR_VERSION_FIELD, TEMPLATE_MINOR_VERSION_FIELD, TEMPLATE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServicePipelineState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String spec;
    private final String templateMajorVersion;
    private final String templateMinorVersion;
    private final String templateName;

    private ServicePipelineState(BuilderImpl builder) {
        this.spec = builder.spec;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
        this.templateName = builder.templateName;
    }

    public final String spec() {
        return this.spec;
    }

    public final String templateMajorVersion() {
        return this.templateMajorVersion;
    }

    public final String templateMinorVersion() {
        return this.templateMinorVersion;
    }

    public final String templateName() {
        return this.templateName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateMinorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServicePipelineState)) {
            return false;
        }
        ServicePipelineState other = (ServicePipelineState)obj;
        return Objects.equals(this.spec(), other.spec()) && Objects.equals(this.templateMajorVersion(), other.templateMajorVersion()) && Objects.equals(this.templateMinorVersion(), other.templateMinorVersion()) && Objects.equals(this.templateName(), other.templateName());
    }

    public final String toString() {
        return ToString.builder((String)"ServicePipelineState").add("Spec", (Object)(this.spec() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateMajorVersion", (Object)this.templateMajorVersion()).add("TemplateMinorVersion", (Object)this.templateMinorVersion()).add("TemplateName", (Object)this.templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "templateMajorVersion": {
                return Optional.ofNullable(clazz.cast(this.templateMajorVersion()));
            }
            case "templateMinorVersion": {
                return Optional.ofNullable(clazz.cast(this.templateMinorVersion()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("spec", SPEC_FIELD);
        map.put("templateMajorVersion", TEMPLATE_MAJOR_VERSION_FIELD);
        map.put("templateMinorVersion", TEMPLATE_MINOR_VERSION_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServicePipelineState, T> g) {
        return obj -> g.apply((ServicePipelineState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String spec;
        private String templateMajorVersion;
        private String templateMinorVersion;
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServicePipelineState model) {
            this.spec(model.spec);
            this.templateMajorVersion(model.templateMajorVersion);
            this.templateMinorVersion(model.templateMinorVersion);
            this.templateName(model.templateName);
        }

        public final String getSpec() {
            return this.spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final String getTemplateMajorVersion() {
            return this.templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return this.templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public ServicePipelineState build() {
            return new ServicePipelineState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServicePipelineState> {
        public Builder spec(String var1);

        public Builder templateMajorVersion(String var1);

        public Builder templateMinorVersion(String var1);

        public Builder templateName(String var1);
    }
}

