/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.RepositoryProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceSyncConfigRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, UpdateServiceSyncConfigRequest> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branch").getter(UpdateServiceSyncConfigRequest.getter(UpdateServiceSyncConfigRequest::branch)).setter(UpdateServiceSyncConfigRequest.setter(Builder::branch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()}).build();
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePath").getter(UpdateServiceSyncConfigRequest.getter(UpdateServiceSyncConfigRequest::filePath)).setter(UpdateServiceSyncConfigRequest.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(UpdateServiceSyncConfigRequest.getter(UpdateServiceSyncConfigRequest::repositoryName)).setter(UpdateServiceSyncConfigRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> REPOSITORY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryProvider").getter(UpdateServiceSyncConfigRequest.getter(UpdateServiceSyncConfigRequest::repositoryProviderAsString)).setter(UpdateServiceSyncConfigRequest.setter(Builder::repositoryProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryProvider").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(UpdateServiceSyncConfigRequest.getter(UpdateServiceSyncConfigRequest::serviceName)).setter(UpdateServiceSyncConfigRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, FILE_PATH_FIELD, REPOSITORY_NAME_FIELD, REPOSITORY_PROVIDER_FIELD, SERVICE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateServiceSyncConfigRequest.memberNameToFieldInitializer();
    private final String branch;
    private final String filePath;
    private final String repositoryName;
    private final String repositoryProvider;
    private final String serviceName;

    private UpdateServiceSyncConfigRequest(BuilderImpl builder) {
        super(builder);
        this.branch = builder.branch;
        this.filePath = builder.filePath;
        this.repositoryName = builder.repositoryName;
        this.repositoryProvider = builder.repositoryProvider;
        this.serviceName = builder.serviceName;
    }

    public final String branch() {
        return this.branch;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final RepositoryProvider repositoryProvider() {
        return RepositoryProvider.fromValue(this.repositoryProvider);
    }

    public final String repositoryProviderAsString() {
        return this.repositoryProvider;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSyncConfigRequest)) {
            return false;
        }
        UpdateServiceSyncConfigRequest other = (UpdateServiceSyncConfigRequest)((Object)obj);
        return Objects.equals(this.branch(), other.branch()) && Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.repositoryProviderAsString(), other.repositoryProviderAsString()) && Objects.equals(this.serviceName(), other.serviceName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServiceSyncConfigRequest").add("Branch", (Object)this.branch()).add("FilePath", (Object)this.filePath()).add("RepositoryName", (Object)this.repositoryName()).add("RepositoryProvider", (Object)this.repositoryProviderAsString()).add("ServiceName", (Object)this.serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "repositoryProvider": {
                return Optional.ofNullable(clazz.cast(this.repositoryProviderAsString()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("branch", BRANCH_FIELD);
        map.put("filePath", FILE_PATH_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("repositoryProvider", REPOSITORY_PROVIDER_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceSyncConfigRequest, T> g) {
        return obj -> g.apply((UpdateServiceSyncConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String branch;
        private String filePath;
        private String repositoryName;
        private String repositoryProvider;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSyncConfigRequest model) {
            super(model);
            this.branch(model.branch);
            this.filePath(model.filePath);
            this.repositoryName(model.repositoryName);
            this.repositoryProvider(model.repositoryProvider);
            this.serviceName(model.serviceName);
        }

        public final String getBranch() {
            return this.branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryProvider() {
            return this.repositoryProvider;
        }

        public final void setRepositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
        }

        @Override
        public final Builder repositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
            return this;
        }

        @Override
        public final Builder repositoryProvider(RepositoryProvider repositoryProvider) {
            this.repositoryProvider(repositoryProvider == null ? null : repositoryProvider.toString());
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceSyncConfigRequest build() {
            return new UpdateServiceSyncConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceSyncConfigRequest> {
        public Builder branch(String var1);

        public Builder filePath(String var1);

        public Builder repositoryName(String var1);

        public Builder repositoryProvider(String var1);

        public Builder repositoryProvider(RepositoryProvider var1);

        public Builder serviceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

