/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionSummary;
import software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse;

public class ListEnvironmentAccountConnectionsPublisher
implements SdkPublisher<ListEnvironmentAccountConnectionsResponse> {
    private final ProtonAsyncClient client;
    private final ListEnvironmentAccountConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentAccountConnectionsPublisher(ProtonAsyncClient client, ListEnvironmentAccountConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentAccountConnectionsPublisher(ProtonAsyncClient client, ListEnvironmentAccountConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentAccountConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnvironmentAccountConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EnvironmentAccountConnectionSummary> environmentAccountConnections() {
        Function<ListEnvironmentAccountConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environmentAccountConnections() != null) {
                return response.environmentAccountConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnvironmentAccountConnectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentAccountConnectionsResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentAccountConnectionsResponse> {
        private ListEnvironmentAccountConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentAccountConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnvironmentAccountConnectionsResponse> nextPage(ListEnvironmentAccountConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentAccountConnectionsPublisher.this.client.listEnvironmentAccountConnections(ListEnvironmentAccountConnectionsPublisher.this.firstRequest);
            }
            return ListEnvironmentAccountConnectionsPublisher.this.client.listEnvironmentAccountConnections((ListEnvironmentAccountConnectionsRequest)((Object)ListEnvironmentAccountConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

