/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.DeploymentUpdateType;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.RepositoryBranchInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEnvironmentRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, UpdateEnvironmentRequest> {
    private static final SdkField<String> CODEBUILD_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codebuildRoleArn").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::codebuildRoleArn)).setter(UpdateEnvironmentRequest.setter(Builder::codebuildRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codebuildRoleArn").build()}).build();
    private static final SdkField<String> COMPONENT_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentRoleArn").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::componentRoleArn)).setter(UpdateEnvironmentRequest.setter(Builder::componentRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRoleArn").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentType").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::deploymentTypeAsString)).setter(UpdateEnvironmentRequest.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::description)).setter(UpdateEnvironmentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentAccountConnectionId").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::environmentAccountConnectionId)).setter(UpdateEnvironmentRequest.setter(Builder::environmentAccountConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountConnectionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::name)).setter(UpdateEnvironmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROTON_SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protonServiceRoleArn").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::protonServiceRoleArn)).setter(UpdateEnvironmentRequest.setter(Builder::protonServiceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protonServiceRoleArn").build()}).build();
    private static final SdkField<RepositoryBranchInput> PROVISIONING_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("provisioningRepository").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::provisioningRepository)).setter(UpdateEnvironmentRequest.setter(Builder::provisioningRepository)).constructor(RepositoryBranchInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRepository").build()}).build();
    private static final SdkField<String> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spec").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::spec)).setter(UpdateEnvironmentRequest.setter(Builder::spec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<String> TEMPLATE_MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateMajorVersion").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::templateMajorVersion)).setter(UpdateEnvironmentRequest.setter(Builder::templateMajorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMajorVersion").build()}).build();
    private static final SdkField<String> TEMPLATE_MINOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateMinorVersion").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::templateMinorVersion)).setter(UpdateEnvironmentRequest.setter(Builder::templateMinorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateMinorVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEBUILD_ROLE_ARN_FIELD, COMPONENT_ROLE_ARN_FIELD, DEPLOYMENT_TYPE_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD, NAME_FIELD, PROTON_SERVICE_ROLE_ARN_FIELD, PROVISIONING_REPOSITORY_FIELD, SPEC_FIELD, TEMPLATE_MAJOR_VERSION_FIELD, TEMPLATE_MINOR_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEnvironmentRequest.memberNameToFieldInitializer();
    private final String codebuildRoleArn;
    private final String componentRoleArn;
    private final String deploymentType;
    private final String description;
    private final String environmentAccountConnectionId;
    private final String name;
    private final String protonServiceRoleArn;
    private final RepositoryBranchInput provisioningRepository;
    private final String spec;
    private final String templateMajorVersion;
    private final String templateMinorVersion;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.codebuildRoleArn = builder.codebuildRoleArn;
        this.componentRoleArn = builder.componentRoleArn;
        this.deploymentType = builder.deploymentType;
        this.description = builder.description;
        this.environmentAccountConnectionId = builder.environmentAccountConnectionId;
        this.name = builder.name;
        this.protonServiceRoleArn = builder.protonServiceRoleArn;
        this.provisioningRepository = builder.provisioningRepository;
        this.spec = builder.spec;
        this.templateMajorVersion = builder.templateMajorVersion;
        this.templateMinorVersion = builder.templateMinorVersion;
    }

    public final String codebuildRoleArn() {
        return this.codebuildRoleArn;
    }

    public final String componentRoleArn() {
        return this.componentRoleArn;
    }

    public final DeploymentUpdateType deploymentType() {
        return DeploymentUpdateType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final String description() {
        return this.description;
    }

    public final String environmentAccountConnectionId() {
        return this.environmentAccountConnectionId;
    }

    public final String name() {
        return this.name;
    }

    public final String protonServiceRoleArn() {
        return this.protonServiceRoleArn;
    }

    public final RepositoryBranchInput provisioningRepository() {
        return this.provisioningRepository;
    }

    public final String spec() {
        return this.spec;
    }

    public final String templateMajorVersion() {
        return this.templateMajorVersion;
    }

    public final String templateMinorVersion() {
        return this.templateMinorVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codebuildRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentAccountConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.protonServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateMajorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateMinorVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.codebuildRoleArn(), other.codebuildRoleArn()) && Objects.equals(this.componentRoleArn(), other.componentRoleArn()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentAccountConnectionId(), other.environmentAccountConnectionId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.protonServiceRoleArn(), other.protonServiceRoleArn()) && Objects.equals(this.provisioningRepository(), other.provisioningRepository()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.templateMajorVersion(), other.templateMajorVersion()) && Objects.equals(this.templateMinorVersion(), other.templateMinorVersion());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEnvironmentRequest").add("CodebuildRoleArn", (Object)this.codebuildRoleArn()).add("ComponentRoleArn", (Object)this.componentRoleArn()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EnvironmentAccountConnectionId", (Object)this.environmentAccountConnectionId()).add("Name", (Object)this.name()).add("ProtonServiceRoleArn", (Object)this.protonServiceRoleArn()).add("ProvisioningRepository", (Object)this.provisioningRepository()).add("Spec", (Object)(this.spec() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateMajorVersion", (Object)this.templateMajorVersion()).add("TemplateMinorVersion", (Object)this.templateMinorVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codebuildRoleArn": {
                return Optional.ofNullable(clazz.cast(this.codebuildRoleArn()));
            }
            case "componentRoleArn": {
                return Optional.ofNullable(clazz.cast(this.componentRoleArn()));
            }
            case "deploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "environmentAccountConnectionId": {
                return Optional.ofNullable(clazz.cast(this.environmentAccountConnectionId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "protonServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.protonServiceRoleArn()));
            }
            case "provisioningRepository": {
                return Optional.ofNullable(clazz.cast(this.provisioningRepository()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "templateMajorVersion": {
                return Optional.ofNullable(clazz.cast(this.templateMajorVersion()));
            }
            case "templateMinorVersion": {
                return Optional.ofNullable(clazz.cast(this.templateMinorVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codebuildRoleArn", CODEBUILD_ROLE_ARN_FIELD);
        map.put("componentRoleArn", COMPONENT_ROLE_ARN_FIELD);
        map.put("deploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("environmentAccountConnectionId", ENVIRONMENT_ACCOUNT_CONNECTION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("protonServiceRoleArn", PROTON_SERVICE_ROLE_ARN_FIELD);
        map.put("provisioningRepository", PROVISIONING_REPOSITORY_FIELD);
        map.put("spec", SPEC_FIELD);
        map.put("templateMajorVersion", TEMPLATE_MAJOR_VERSION_FIELD);
        map.put("templateMinorVersion", TEMPLATE_MINOR_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String codebuildRoleArn;
        private String componentRoleArn;
        private String deploymentType;
        private String description;
        private String environmentAccountConnectionId;
        private String name;
        private String protonServiceRoleArn;
        private RepositoryBranchInput provisioningRepository;
        private String spec;
        private String templateMajorVersion;
        private String templateMinorVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            super(model);
            this.codebuildRoleArn(model.codebuildRoleArn);
            this.componentRoleArn(model.componentRoleArn);
            this.deploymentType(model.deploymentType);
            this.description(model.description);
            this.environmentAccountConnectionId(model.environmentAccountConnectionId);
            this.name(model.name);
            this.protonServiceRoleArn(model.protonServiceRoleArn);
            this.provisioningRepository(model.provisioningRepository);
            this.spec(model.spec);
            this.templateMajorVersion(model.templateMajorVersion);
            this.templateMinorVersion(model.templateMinorVersion);
        }

        public final String getCodebuildRoleArn() {
            return this.codebuildRoleArn;
        }

        public final void setCodebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
        }

        @Override
        public final Builder codebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
            return this;
        }

        public final String getComponentRoleArn() {
            return this.componentRoleArn;
        }

        public final void setComponentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
        }

        @Override
        public final Builder componentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentUpdateType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentAccountConnectionId() {
            return this.environmentAccountConnectionId;
        }

        public final void setEnvironmentAccountConnectionId(String environmentAccountConnectionId) {
            this.environmentAccountConnectionId = environmentAccountConnectionId;
        }

        @Override
        public final Builder environmentAccountConnectionId(String environmentAccountConnectionId) {
            this.environmentAccountConnectionId = environmentAccountConnectionId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtonServiceRoleArn() {
            return this.protonServiceRoleArn;
        }

        public final void setProtonServiceRoleArn(String protonServiceRoleArn) {
            this.protonServiceRoleArn = protonServiceRoleArn;
        }

        @Override
        public final Builder protonServiceRoleArn(String protonServiceRoleArn) {
            this.protonServiceRoleArn = protonServiceRoleArn;
            return this;
        }

        public final RepositoryBranchInput.Builder getProvisioningRepository() {
            return this.provisioningRepository != null ? this.provisioningRepository.toBuilder() : null;
        }

        public final void setProvisioningRepository(RepositoryBranchInput.BuilderImpl provisioningRepository) {
            this.provisioningRepository = provisioningRepository != null ? provisioningRepository.build() : null;
        }

        @Override
        public final Builder provisioningRepository(RepositoryBranchInput provisioningRepository) {
            this.provisioningRepository = provisioningRepository;
            return this;
        }

        public final String getSpec() {
            return this.spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        public final String getTemplateMajorVersion() {
            return this.templateMajorVersion;
        }

        public final void setTemplateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
        }

        @Override
        public final Builder templateMajorVersion(String templateMajorVersion) {
            this.templateMajorVersion = templateMajorVersion;
            return this;
        }

        public final String getTemplateMinorVersion() {
            return this.templateMinorVersion;
        }

        public final void setTemplateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
        }

        @Override
        public final Builder templateMinorVersion(String templateMinorVersion) {
            this.templateMinorVersion = templateMinorVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        public Builder codebuildRoleArn(String var1);

        public Builder componentRoleArn(String var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentUpdateType var1);

        public Builder description(String var1);

        public Builder environmentAccountConnectionId(String var1);

        public Builder name(String var1);

        public Builder protonServiceRoleArn(String var1);

        public Builder provisioningRepository(RepositoryBranchInput var1);

        default public Builder provisioningRepository(Consumer<RepositoryBranchInput.Builder> provisioningRepository) {
            return this.provisioningRepository((RepositoryBranchInput)((RepositoryBranchInput.Builder)RepositoryBranchInput.builder().applyMutation(provisioningRepository)).build());
        }

        public Builder spec(String var1);

        public Builder templateMajorVersion(String var1);

        public Builder templateMinorVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

