/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.RepositoryProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRepositoryRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, GetRepositoryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetRepositoryRequest.getter(GetRepositoryRequest::name)).setter(GetRepositoryRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(GetRepositoryRequest.getter(GetRepositoryRequest::providerAsString)).setter(GetRepositoryRequest.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRepositoryRequest.memberNameToFieldInitializer();
    private final String name;
    private final String provider;

    private GetRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.provider = builder.provider;
    }

    public final String name() {
        return this.name;
    }

    public final RepositoryProvider provider() {
        return RepositoryProvider.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRepositoryRequest)) {
            return false;
        }
        GetRepositoryRequest other = (GetRepositoryRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.providerAsString(), other.providerAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetRepositoryRequest").add("Name", (Object)this.name()).add("Provider", (Object)this.providerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("name", NAME_FIELD);
        map.put("provider", PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRepositoryRequest, T> g) {
        return obj -> g.apply((GetRepositoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String name;
        private String provider;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRepositoryRequest model) {
            super(model);
            this.name(model.name);
            this.provider(model.provider);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(RepositoryProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRepositoryRequest build() {
            return new GetRepositoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRepositoryRequest> {
        public Builder name(String var1);

        public Builder provider(String var1);

        public Builder provider(RepositoryProvider var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

