/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInput;
import software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInputListCopier;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.ServiceTemplateSupportedComponentSourceInputListCopier;
import software.amazon.awssdk.services.proton.model.ServiceTemplateSupportedComponentSourceType;
import software.amazon.awssdk.services.proton.model.Tag;
import software.amazon.awssdk.services.proton.model.TagListCopier;
import software.amazon.awssdk.services.proton.model.TemplateVersionSourceInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceTemplateVersionRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, CreateServiceTemplateVersionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateServiceTemplateVersionRequest.getter(CreateServiceTemplateVersionRequest::clientToken)).setter(CreateServiceTemplateVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<CompatibleEnvironmentTemplateInput>> COMPATIBLE_ENVIRONMENT_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("compatibleEnvironmentTemplates").getter(CreateServiceTemplateVersionRequest.getter(CreateServiceTemplateVersionRequest::compatibleEnvironmentTemplates)).setter(CreateServiceTemplateVersionRequest.setter(Builder::compatibleEnvironmentTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleEnvironmentTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompatibleEnvironmentTemplateInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateServiceTemplateVersionRequest.getter(CreateServiceTemplateVersionRequest::description)).setter(CreateServiceTemplateVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("majorVersion").getter(CreateServiceTemplateVersionRequest.getter(CreateServiceTemplateVersionRequest::majorVersion)).setter(CreateServiceTemplateVersionRequest.setter(Builder::majorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersion").build()}).build();
    private static final SdkField<TemplateVersionSourceInput> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(CreateServiceTemplateVersionRequest.getter(CreateServiceTemplateVersionRequest::source)).setter(CreateServiceTemplateVersionRequest.setter(Builder::source)).constructor(TemplateVersionSourceInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_COMPONENT_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedComponentSources").getter(CreateServiceTemplateVersionRequest.getter(CreateServiceTemplateVersionRequest::supportedComponentSourcesAsStrings)).setter(CreateServiceTemplateVersionRequest.setter(Builder::supportedComponentSourcesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedComponentSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateServiceTemplateVersionRequest.getter(CreateServiceTemplateVersionRequest::tags)).setter(CreateServiceTemplateVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(CreateServiceTemplateVersionRequest.getter(CreateServiceTemplateVersionRequest::templateName)).setter(CreateServiceTemplateVersionRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, COMPATIBLE_ENVIRONMENT_TEMPLATES_FIELD, DESCRIPTION_FIELD, MAJOR_VERSION_FIELD, SOURCE_FIELD, SUPPORTED_COMPONENT_SOURCES_FIELD, TAGS_FIELD, TEMPLATE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateServiceTemplateVersionRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final List<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates;
    private final String description;
    private final String majorVersion;
    private final TemplateVersionSourceInput source;
    private final List<String> supportedComponentSources;
    private final List<Tag> tags;
    private final String templateName;

    private CreateServiceTemplateVersionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.compatibleEnvironmentTemplates = builder.compatibleEnvironmentTemplates;
        this.description = builder.description;
        this.majorVersion = builder.majorVersion;
        this.source = builder.source;
        this.supportedComponentSources = builder.supportedComponentSources;
        this.tags = builder.tags;
        this.templateName = builder.templateName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasCompatibleEnvironmentTemplates() {
        return this.compatibleEnvironmentTemplates != null && !(this.compatibleEnvironmentTemplates instanceof SdkAutoConstructList);
    }

    public final List<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates() {
        return this.compatibleEnvironmentTemplates;
    }

    public final String description() {
        return this.description;
    }

    public final String majorVersion() {
        return this.majorVersion;
    }

    public final TemplateVersionSourceInput source() {
        return this.source;
    }

    public final List<ServiceTemplateSupportedComponentSourceType> supportedComponentSources() {
        return ServiceTemplateSupportedComponentSourceInputListCopier.copyStringToEnum(this.supportedComponentSources);
    }

    public final boolean hasSupportedComponentSources() {
        return this.supportedComponentSources != null && !(this.supportedComponentSources instanceof SdkAutoConstructList);
    }

    public final List<String> supportedComponentSourcesAsStrings() {
        return this.supportedComponentSources;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String templateName() {
        return this.templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompatibleEnvironmentTemplates() ? this.compatibleEnvironmentTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedComponentSources() ? this.supportedComponentSourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceTemplateVersionRequest)) {
            return false;
        }
        CreateServiceTemplateVersionRequest other = (CreateServiceTemplateVersionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && this.hasCompatibleEnvironmentTemplates() == other.hasCompatibleEnvironmentTemplates() && Objects.equals(this.compatibleEnvironmentTemplates(), other.compatibleEnvironmentTemplates()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.majorVersion(), other.majorVersion()) && Objects.equals(this.source(), other.source()) && this.hasSupportedComponentSources() == other.hasSupportedComponentSources() && Objects.equals(this.supportedComponentSourcesAsStrings(), other.supportedComponentSourcesAsStrings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateName(), other.templateName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceTemplateVersionRequest").add("ClientToken", (Object)this.clientToken()).add("CompatibleEnvironmentTemplates", this.hasCompatibleEnvironmentTemplates() ? this.compatibleEnvironmentTemplates() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("MajorVersion", (Object)this.majorVersion()).add("Source", (Object)this.source()).add("SupportedComponentSources", this.hasSupportedComponentSources() ? this.supportedComponentSourcesAsStrings() : null).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateName", (Object)this.templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "compatibleEnvironmentTemplates": {
                return Optional.ofNullable(clazz.cast(this.compatibleEnvironmentTemplates()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "majorVersion": {
                return Optional.ofNullable(clazz.cast(this.majorVersion()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "supportedComponentSources": {
                return Optional.ofNullable(clazz.cast(this.supportedComponentSourcesAsStrings()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("compatibleEnvironmentTemplates", COMPATIBLE_ENVIRONMENT_TEMPLATES_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("majorVersion", MAJOR_VERSION_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("supportedComponentSources", SUPPORTED_COMPONENT_SOURCES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceTemplateVersionRequest, T> g) {
        return obj -> g.apply((CreateServiceTemplateVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private List<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String majorVersion;
        private TemplateVersionSourceInput source;
        private List<String> supportedComponentSources = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceTemplateVersionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.compatibleEnvironmentTemplates(model.compatibleEnvironmentTemplates);
            this.description(model.description);
            this.majorVersion(model.majorVersion);
            this.source(model.source);
            this.supportedComponentSourcesWithStrings(model.supportedComponentSources);
            this.tags(model.tags);
            this.templateName(model.templateName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<CompatibleEnvironmentTemplateInput.Builder> getCompatibleEnvironmentTemplates() {
            List<CompatibleEnvironmentTemplateInput.Builder> result = CompatibleEnvironmentTemplateInputListCopier.copyToBuilder(this.compatibleEnvironmentTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompatibleEnvironmentTemplates(Collection<CompatibleEnvironmentTemplateInput.BuilderImpl> compatibleEnvironmentTemplates) {
            this.compatibleEnvironmentTemplates = CompatibleEnvironmentTemplateInputListCopier.copyFromBuilder(compatibleEnvironmentTemplates);
        }

        @Override
        public final Builder compatibleEnvironmentTemplates(Collection<CompatibleEnvironmentTemplateInput> compatibleEnvironmentTemplates) {
            this.compatibleEnvironmentTemplates = CompatibleEnvironmentTemplateInputListCopier.copy(compatibleEnvironmentTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleEnvironmentTemplates(CompatibleEnvironmentTemplateInput ... compatibleEnvironmentTemplates) {
            this.compatibleEnvironmentTemplates(Arrays.asList(compatibleEnvironmentTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleEnvironmentTemplates(Consumer<CompatibleEnvironmentTemplateInput.Builder> ... compatibleEnvironmentTemplates) {
            this.compatibleEnvironmentTemplates(Stream.of(compatibleEnvironmentTemplates).map(c -> (CompatibleEnvironmentTemplateInput)((CompatibleEnvironmentTemplateInput.Builder)CompatibleEnvironmentTemplateInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMajorVersion() {
            return this.majorVersion;
        }

        public final void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public final Builder majorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public final TemplateVersionSourceInput.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(TemplateVersionSourceInput.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TemplateVersionSourceInput source) {
            this.source = source;
            return this;
        }

        public final Collection<String> getSupportedComponentSources() {
            if (this.supportedComponentSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedComponentSources;
        }

        public final void setSupportedComponentSources(Collection<String> supportedComponentSources) {
            this.supportedComponentSources = ServiceTemplateSupportedComponentSourceInputListCopier.copy(supportedComponentSources);
        }

        @Override
        public final Builder supportedComponentSourcesWithStrings(Collection<String> supportedComponentSources) {
            this.supportedComponentSources = ServiceTemplateSupportedComponentSourceInputListCopier.copy(supportedComponentSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComponentSourcesWithStrings(String ... supportedComponentSources) {
            this.supportedComponentSourcesWithStrings(Arrays.asList(supportedComponentSources));
            return this;
        }

        @Override
        public final Builder supportedComponentSources(Collection<ServiceTemplateSupportedComponentSourceType> supportedComponentSources) {
            this.supportedComponentSources = ServiceTemplateSupportedComponentSourceInputListCopier.copyEnumToString(supportedComponentSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComponentSources(ServiceTemplateSupportedComponentSourceType ... supportedComponentSources) {
            this.supportedComponentSources(Arrays.asList(supportedComponentSources));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceTemplateVersionRequest build() {
            return new CreateServiceTemplateVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceTemplateVersionRequest> {
        public Builder clientToken(String var1);

        public Builder compatibleEnvironmentTemplates(Collection<CompatibleEnvironmentTemplateInput> var1);

        public Builder compatibleEnvironmentTemplates(CompatibleEnvironmentTemplateInput ... var1);

        public Builder compatibleEnvironmentTemplates(Consumer<CompatibleEnvironmentTemplateInput.Builder> ... var1);

        public Builder description(String var1);

        public Builder majorVersion(String var1);

        public Builder source(TemplateVersionSourceInput var1);

        default public Builder source(Consumer<TemplateVersionSourceInput.Builder> source) {
            return this.source((TemplateVersionSourceInput)((TemplateVersionSourceInput.Builder)TemplateVersionSourceInput.builder().applyMutation(source)).build());
        }

        public Builder supportedComponentSourcesWithStrings(Collection<String> var1);

        public Builder supportedComponentSourcesWithStrings(String ... var1);

        public Builder supportedComponentSources(Collection<ServiceTemplateSupportedComponentSourceType> var1);

        public Builder supportedComponentSources(ServiceTemplateSupportedComponentSourceType ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder templateName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

