/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.DeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Component
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Component> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Component.getter(Component::arn)).setter(Component.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Component.getter(Component::createdAt)).setter(Component.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentStatus").getter(Component.getter(Component::deploymentStatusAsString)).setter(Component.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentStatusMessage").getter(Component.getter(Component::deploymentStatusMessage)).setter(Component.setter(Builder::deploymentStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatusMessage").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Component.getter(Component::description)).setter(Component.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(Component.getter(Component::environmentName)).setter(Component.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastAttemptedDeploymentId").getter(Component.getter(Component::lastAttemptedDeploymentId)).setter(Component.setter(Builder::lastAttemptedDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptedDeploymentId").build()}).build();
    private static final SdkField<String> LAST_CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastClientRequestToken").getter(Component.getter(Component::lastClientRequestToken)).setter(Component.setter(Builder::lastClientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastClientRequestToken").build()}).build();
    private static final SdkField<Instant> LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastDeploymentAttemptedAt").getter(Component.getter(Component::lastDeploymentAttemptedAt)).setter(Component.setter(Builder::lastDeploymentAttemptedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentAttemptedAt").build()}).build();
    private static final SdkField<Instant> LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastDeploymentSucceededAt").getter(Component.getter(Component::lastDeploymentSucceededAt)).setter(Component.setter(Builder::lastDeploymentSucceededAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentSucceededAt").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(Component.getter(Component::lastModifiedAt)).setter(Component.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<String> LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastSucceededDeploymentId").getter(Component.getter(Component::lastSucceededDeploymentId)).setter(Component.setter(Builder::lastSucceededDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSucceededDeploymentId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Component.getter(Component::name)).setter(Component.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceInstanceName").getter(Component.getter(Component::serviceInstanceName)).setter(Component.setter(Builder::serviceInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(Component.getter(Component::serviceName)).setter(Component.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> SERVICE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceSpec").getter(Component.getter(Component::serviceSpec)).setter(Component.setter(Builder::serviceSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSpec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_STATUS_MESSAGE_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_NAME_FIELD, LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD, LAST_CLIENT_REQUEST_TOKEN_FIELD, LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD, LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD, LAST_MODIFIED_AT_FIELD, LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD, NAME_FIELD, SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD, SERVICE_SPEC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Component.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String deploymentStatus;
    private final String deploymentStatusMessage;
    private final String description;
    private final String environmentName;
    private final String lastAttemptedDeploymentId;
    private final String lastClientRequestToken;
    private final Instant lastDeploymentAttemptedAt;
    private final Instant lastDeploymentSucceededAt;
    private final Instant lastModifiedAt;
    private final String lastSucceededDeploymentId;
    private final String name;
    private final String serviceInstanceName;
    private final String serviceName;
    private final String serviceSpec;

    private Component(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentStatusMessage = builder.deploymentStatusMessage;
        this.description = builder.description;
        this.environmentName = builder.environmentName;
        this.lastAttemptedDeploymentId = builder.lastAttemptedDeploymentId;
        this.lastClientRequestToken = builder.lastClientRequestToken;
        this.lastDeploymentAttemptedAt = builder.lastDeploymentAttemptedAt;
        this.lastDeploymentSucceededAt = builder.lastDeploymentSucceededAt;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.lastSucceededDeploymentId = builder.lastSucceededDeploymentId;
        this.name = builder.name;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
        this.serviceSpec = builder.serviceSpec;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(this.deploymentStatus);
    }

    public final String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public final String deploymentStatusMessage() {
        return this.deploymentStatusMessage;
    }

    public final String description() {
        return this.description;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String lastAttemptedDeploymentId() {
        return this.lastAttemptedDeploymentId;
    }

    public final String lastClientRequestToken() {
        return this.lastClientRequestToken;
    }

    public final Instant lastDeploymentAttemptedAt() {
        return this.lastDeploymentAttemptedAt;
    }

    public final Instant lastDeploymentSucceededAt() {
        return this.lastDeploymentSucceededAt;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String lastSucceededDeploymentId() {
        return this.lastSucceededDeploymentId;
    }

    public final String name() {
        return this.name;
    }

    public final String serviceInstanceName() {
        return this.serviceInstanceName;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String serviceSpec() {
        return this.serviceSpec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAttemptedDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastClientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentAttemptedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentSucceededAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSucceededDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Component)) {
            return false;
        }
        Component other = (Component)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.deploymentStatusMessage(), other.deploymentStatusMessage()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.lastAttemptedDeploymentId(), other.lastAttemptedDeploymentId()) && Objects.equals(this.lastClientRequestToken(), other.lastClientRequestToken()) && Objects.equals(this.lastDeploymentAttemptedAt(), other.lastDeploymentAttemptedAt()) && Objects.equals(this.lastDeploymentSucceededAt(), other.lastDeploymentSucceededAt()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.lastSucceededDeploymentId(), other.lastSucceededDeploymentId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.serviceInstanceName(), other.serviceInstanceName()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceSpec(), other.serviceSpec());
    }

    public final String toString() {
        return ToString.builder((String)"Component").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("DeploymentStatusMessage", (Object)(this.deploymentStatusMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EnvironmentName", (Object)this.environmentName()).add("LastAttemptedDeploymentId", (Object)this.lastAttemptedDeploymentId()).add("LastClientRequestToken", (Object)this.lastClientRequestToken()).add("LastDeploymentAttemptedAt", (Object)this.lastDeploymentAttemptedAt()).add("LastDeploymentSucceededAt", (Object)this.lastDeploymentSucceededAt()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("LastSucceededDeploymentId", (Object)this.lastSucceededDeploymentId()).add("Name", (Object)this.name()).add("ServiceInstanceName", (Object)this.serviceInstanceName()).add("ServiceName", (Object)this.serviceName()).add("ServiceSpec", (Object)(this.serviceSpec() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "deploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "deploymentStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusMessage()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "lastAttemptedDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.lastAttemptedDeploymentId()));
            }
            case "lastClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.lastClientRequestToken()));
            }
            case "lastDeploymentAttemptedAt": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentAttemptedAt()));
            }
            case "lastDeploymentSucceededAt": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentSucceededAt()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "lastSucceededDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.lastSucceededDeploymentId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "serviceInstanceName": {
                return Optional.ofNullable(clazz.cast(this.serviceInstanceName()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "serviceSpec": {
                return Optional.ofNullable(clazz.cast(this.serviceSpec()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("deploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("deploymentStatusMessage", DEPLOYMENT_STATUS_MESSAGE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("lastAttemptedDeploymentId", LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD);
        map.put("lastClientRequestToken", LAST_CLIENT_REQUEST_TOKEN_FIELD);
        map.put("lastDeploymentAttemptedAt", LAST_DEPLOYMENT_ATTEMPTED_AT_FIELD);
        map.put("lastDeploymentSucceededAt", LAST_DEPLOYMENT_SUCCEEDED_AT_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("lastSucceededDeploymentId", LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("serviceInstanceName", SERVICE_INSTANCE_NAME_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("serviceSpec", SERVICE_SPEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Component, T> g) {
        return obj -> g.apply((Component)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String deploymentStatus;
        private String deploymentStatusMessage;
        private String description;
        private String environmentName;
        private String lastAttemptedDeploymentId;
        private String lastClientRequestToken;
        private Instant lastDeploymentAttemptedAt;
        private Instant lastDeploymentSucceededAt;
        private Instant lastModifiedAt;
        private String lastSucceededDeploymentId;
        private String name;
        private String serviceInstanceName;
        private String serviceName;
        private String serviceSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(Component model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.deploymentStatus(model.deploymentStatus);
            this.deploymentStatusMessage(model.deploymentStatusMessage);
            this.description(model.description);
            this.environmentName(model.environmentName);
            this.lastAttemptedDeploymentId(model.lastAttemptedDeploymentId);
            this.lastClientRequestToken(model.lastClientRequestToken);
            this.lastDeploymentAttemptedAt(model.lastDeploymentAttemptedAt);
            this.lastDeploymentSucceededAt(model.lastDeploymentSucceededAt);
            this.lastModifiedAt(model.lastModifiedAt);
            this.lastSucceededDeploymentId(model.lastSucceededDeploymentId);
            this.name(model.name);
            this.serviceInstanceName(model.serviceInstanceName);
            this.serviceName(model.serviceName);
            this.serviceSpec(model.serviceSpec);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDeploymentStatusMessage() {
            return this.deploymentStatusMessage;
        }

        public final void setDeploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
        }

        @Override
        public final Builder deploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getLastAttemptedDeploymentId() {
            return this.lastAttemptedDeploymentId;
        }

        public final void setLastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
        }

        @Override
        public final Builder lastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
            return this;
        }

        public final String getLastClientRequestToken() {
            return this.lastClientRequestToken;
        }

        public final void setLastClientRequestToken(String lastClientRequestToken) {
            this.lastClientRequestToken = lastClientRequestToken;
        }

        @Override
        public final Builder lastClientRequestToken(String lastClientRequestToken) {
            this.lastClientRequestToken = lastClientRequestToken;
            return this;
        }

        public final Instant getLastDeploymentAttemptedAt() {
            return this.lastDeploymentAttemptedAt;
        }

        public final void setLastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt) {
            this.lastDeploymentAttemptedAt = lastDeploymentAttemptedAt;
        }

        @Override
        public final Builder lastDeploymentAttemptedAt(Instant lastDeploymentAttemptedAt) {
            this.lastDeploymentAttemptedAt = lastDeploymentAttemptedAt;
            return this;
        }

        public final Instant getLastDeploymentSucceededAt() {
            return this.lastDeploymentSucceededAt;
        }

        public final void setLastDeploymentSucceededAt(Instant lastDeploymentSucceededAt) {
            this.lastDeploymentSucceededAt = lastDeploymentSucceededAt;
        }

        @Override
        public final Builder lastDeploymentSucceededAt(Instant lastDeploymentSucceededAt) {
            this.lastDeploymentSucceededAt = lastDeploymentSucceededAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getLastSucceededDeploymentId() {
            return this.lastSucceededDeploymentId;
        }

        public final void setLastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
        }

        @Override
        public final Builder lastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServiceInstanceName() {
            return this.serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceSpec() {
            return this.serviceSpec;
        }

        public final void setServiceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
        }

        @Override
        public final Builder serviceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
            return this;
        }

        public Component build() {
            return new Component(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Component> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(DeploymentStatus var1);

        public Builder deploymentStatusMessage(String var1);

        public Builder description(String var1);

        public Builder environmentName(String var1);

        public Builder lastAttemptedDeploymentId(String var1);

        public Builder lastClientRequestToken(String var1);

        public Builder lastDeploymentAttemptedAt(Instant var1);

        public Builder lastDeploymentSucceededAt(Instant var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder lastSucceededDeploymentId(String var1);

        public Builder name(String var1);

        public Builder serviceInstanceName(String var1);

        public Builder serviceName(String var1);

        public Builder serviceSpec(String var1);
    }
}

