/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.polly.PollyClient;
import software.amazon.awssdk.services.polly.internal.UserAgentUtils;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse;

public class ListSpeechSynthesisTasksIterable
implements SdkIterable<ListSpeechSynthesisTasksResponse> {
    private final PollyClient client;
    private final ListSpeechSynthesisTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSpeechSynthesisTasksIterable(PollyClient client, ListSpeechSynthesisTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSpeechSynthesisTasksResponseFetcher();
    }

    public Iterator<ListSpeechSynthesisTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSpeechSynthesisTasksResponseFetcher
    implements SyncPageFetcher<ListSpeechSynthesisTasksResponse> {
        private ListSpeechSynthesisTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListSpeechSynthesisTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSpeechSynthesisTasksResponse nextPage(ListSpeechSynthesisTasksResponse previousPage) {
            if (previousPage == null) {
                return ListSpeechSynthesisTasksIterable.this.client.listSpeechSynthesisTasks(ListSpeechSynthesisTasksIterable.this.firstRequest);
            }
            return ListSpeechSynthesisTasksIterable.this.client.listSpeechSynthesisTasks((ListSpeechSynthesisTasksRequest)((Object)ListSpeechSynthesisTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

