/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pipes.model.HeaderParametersMapCopier;
import software.amazon.awssdk.services.pipes.model.PathParameterListCopier;
import software.amazon.awssdk.services.pipes.model.QueryStringParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeTargetHttpParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeTargetHttpParameters> {
    private static final SdkField<List<String>> PATH_PARAMETER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PathParameterValues").getter(PipeTargetHttpParameters.getter(PipeTargetHttpParameters::pathParameterValues)).setter(PipeTargetHttpParameters.setter(Builder::pathParameterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathParameterValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> HEADER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("HeaderParameters").getter(PipeTargetHttpParameters.getter(PipeTargetHttpParameters::headerParameters)).setter(PipeTargetHttpParameters.setter(Builder::headerParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> QUERY_STRING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("QueryStringParameters").getter(PipeTargetHttpParameters.getter(PipeTargetHttpParameters::queryStringParameters)).setter(PipeTargetHttpParameters.setter(Builder::queryStringParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_PARAMETER_VALUES_FIELD, HEADER_PARAMETERS_FIELD, QUERY_STRING_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipeTargetHttpParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> pathParameterValues;
    private final Map<String, String> headerParameters;
    private final Map<String, String> queryStringParameters;

    private PipeTargetHttpParameters(BuilderImpl builder) {
        this.pathParameterValues = builder.pathParameterValues;
        this.headerParameters = builder.headerParameters;
        this.queryStringParameters = builder.queryStringParameters;
    }

    public final boolean hasPathParameterValues() {
        return this.pathParameterValues != null && !(this.pathParameterValues instanceof SdkAutoConstructList);
    }

    public final List<String> pathParameterValues() {
        return this.pathParameterValues;
    }

    public final boolean hasHeaderParameters() {
        return this.headerParameters != null && !(this.headerParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> headerParameters() {
        return this.headerParameters;
    }

    public final boolean hasQueryStringParameters() {
        return this.queryStringParameters != null && !(this.queryStringParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> queryStringParameters() {
        return this.queryStringParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPathParameterValues() ? this.pathParameterValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaderParameters() ? this.headerParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryStringParameters() ? this.queryStringParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetHttpParameters)) {
            return false;
        }
        PipeTargetHttpParameters other = (PipeTargetHttpParameters)obj;
        return this.hasPathParameterValues() == other.hasPathParameterValues() && Objects.equals(this.pathParameterValues(), other.pathParameterValues()) && this.hasHeaderParameters() == other.hasHeaderParameters() && Objects.equals(this.headerParameters(), other.headerParameters()) && this.hasQueryStringParameters() == other.hasQueryStringParameters() && Objects.equals(this.queryStringParameters(), other.queryStringParameters());
    }

    public final String toString() {
        return ToString.builder((String)"PipeTargetHttpParameters").add("PathParameterValues", (Object)(this.pathParameterValues() == null ? null : "*** Sensitive Data Redacted ***")).add("HeaderParameters", (Object)(this.headerParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("QueryStringParameters", (Object)(this.queryStringParameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PathParameterValues": {
                return Optional.ofNullable(clazz.cast(this.pathParameterValues()));
            }
            case "HeaderParameters": {
                return Optional.ofNullable(clazz.cast(this.headerParameters()));
            }
            case "QueryStringParameters": {
                return Optional.ofNullable(clazz.cast(this.queryStringParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PathParameterValues", PATH_PARAMETER_VALUES_FIELD);
        map.put("HeaderParameters", HEADER_PARAMETERS_FIELD);
        map.put("QueryStringParameters", QUERY_STRING_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipeTargetHttpParameters, T> g) {
        return obj -> g.apply((PipeTargetHttpParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> pathParameterValues = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> headerParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> queryStringParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipeTargetHttpParameters model) {
            this.pathParameterValues(model.pathParameterValues);
            this.headerParameters(model.headerParameters);
            this.queryStringParameters(model.queryStringParameters);
        }

        public final Collection<String> getPathParameterValues() {
            if (this.pathParameterValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pathParameterValues;
        }

        public final void setPathParameterValues(Collection<String> pathParameterValues) {
            this.pathParameterValues = PathParameterListCopier.copy(pathParameterValues);
        }

        @Override
        public final Builder pathParameterValues(Collection<String> pathParameterValues) {
            this.pathParameterValues = PathParameterListCopier.copy(pathParameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathParameterValues(String ... pathParameterValues) {
            this.pathParameterValues(Arrays.asList(pathParameterValues));
            return this;
        }

        public final Map<String, String> getHeaderParameters() {
            if (this.headerParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.headerParameters;
        }

        public final void setHeaderParameters(Map<String, String> headerParameters) {
            this.headerParameters = HeaderParametersMapCopier.copy(headerParameters);
        }

        @Override
        public final Builder headerParameters(Map<String, String> headerParameters) {
            this.headerParameters = HeaderParametersMapCopier.copy(headerParameters);
            return this;
        }

        public final Map<String, String> getQueryStringParameters() {
            if (this.queryStringParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.queryStringParameters;
        }

        public final void setQueryStringParameters(Map<String, String> queryStringParameters) {
            this.queryStringParameters = QueryStringParametersMapCopier.copy(queryStringParameters);
        }

        @Override
        public final Builder queryStringParameters(Map<String, String> queryStringParameters) {
            this.queryStringParameters = QueryStringParametersMapCopier.copy(queryStringParameters);
            return this;
        }

        public PipeTargetHttpParameters build() {
            return new PipeTargetHttpParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeTargetHttpParameters> {
        public Builder pathParameterValues(Collection<String> var1);

        public Builder pathParameterValues(String ... var1);

        public Builder headerParameters(Map<String, String> var1);

        public Builder queryStringParameters(Map<String, String> var1);
    }
}

