/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EpochTimeUnit {
    MILLISECONDS("MILLISECONDS"),
    SECONDS("SECONDS"),
    MICROSECONDS("MICROSECONDS"),
    NANOSECONDS("NANOSECONDS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EpochTimeUnit> VALUE_MAP;
    private final String value;

    private EpochTimeUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EpochTimeUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EpochTimeUnit> knownValues() {
        EnumSet<EpochTimeUnit> knownValues = EnumSet.allOf(EpochTimeUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EpochTimeUnit.class, EpochTimeUnit::toString);
    }
}

